/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.api.terrain.TerrainSegment;
import thut.api.terrain.WorldTerrain;

public class TerrainManager {
    public static final String TERRAIN = "pokecubeTerrainData";
    private static TerrainManager terrain;
    public HashMap<Integer, WorldTerrain> map = new HashMap();

    public static void clear() {
        terrain = null;
    }

    public static TerrainManager getInstance() {
        if (terrain == null) {
            terrain = new TerrainManager();
        }
        return terrain;
    }

    public TerrainManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void ChunkLoadEvent(ChunkDataEvent.Load evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        try {
            NBTTagCompound nbt = evt.getData();
            NBTTagCompound terrainData = nbt.func_74775_l(TERRAIN);
            TerrainManager.getInstance().getTerrain(evt.getWorld()).loadTerrain(terrainData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void ChunkSaveEvent(ChunkDataEvent.Save evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        try {
            NBTTagCompound nbt = evt.getData();
            NBTTagCompound terrainData = new NBTTagCompound();
            TerrainManager.getInstance().getTerrain(evt.getWorld()).saveTerrain(terrainData, evt.getChunk().field_76635_g, evt.getChunk().field_76647_h);
            nbt.func_74782_a(TERRAIN, (NBTBase)terrainData);
            if (!evt.getChunk().func_177410_o()) {
                TerrainManager.getInstance().getTerrain(evt.getWorld()).removeTerrain(evt.getChunk().field_76635_g, evt.getChunk().field_76647_h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void ChunkWatchEvent(ChunkWatchEvent.Watch evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        NBTTagCompound terrainData = new NBTTagCompound();
        TerrainManager.getInstance().getTerrain(evt.getPlayer().field_70170_p).saveTerrain(terrainData, evt.getChunk().field_77276_a, evt.getChunk().field_77275_b);
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_150786_a(terrainData);
        PacketHandler.MessageClient message = new PacketHandler.MessageClient(buffer);
        PacketHandler.packetPipeline.sendToAll((IMessage)message);
    }

    public WorldTerrain getTerrain(int id) {
        if (this.map.get(id) == null) {
            this.map.put(id, new WorldTerrain(id));
        }
        return this.map.get(id);
    }

    public WorldTerrain getTerrain(World worldObj) {
        int id = worldObj.field_73011_w.getDimension();
        return this.getTerrain(id);
    }

    public TerrainSegment getTerrain(World world, BlockPos p) {
        return this.getTerrain(world, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
    }

    public TerrainSegment getTerrain(World worldObj, double x, double y, double z) {
        int i = MathHelper.func_76128_c((double)(x / 16.0));
        int j = MathHelper.func_76128_c((double)(y / 16.0));
        int k = MathHelper.func_76128_c((double)(z / 16.0));
        TerrainSegment ret = this.getTerrain(worldObj).getTerrain(i, j, k);
        ret.initBiomes(worldObj);
        return ret;
    }

    public TerrainSegment getTerrainForEntity(Entity e) {
        if (e == null) {
            return null;
        }
        return this.getTerrain(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public TerrainSegment getTerrian(World worldObj, Vector3 v) {
        return this.getTerrain(worldObj, v.x, v.y, v.z);
    }

    @SubscribeEvent
    public void PlayerLoggout(PlayerEvent.PlayerLoggedOutEvent evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            TerrainManager.clear();
        }
    }

    @SubscribeEvent
    public void WorldLoadEvent(WorldEvent.Load evt) {
        TerrainManager.getInstance().getTerrain(evt.getWorld());
    }

    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload evt) {
        if (evt.getWorld().field_73011_w.getDimension() == 0 && FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            TerrainManager.clear();
        }
    }
}

