/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import thut.api.terrain.BiomeDatabase;

public class BiomeType
extends IForgeRegistryEntry.Impl<BiomeType> {
    private static final ArrayList<BiomeType> values = Lists.newArrayList();
    public static final BiomeType NONE = new BiomeType("none", "none");
    public static final BiomeType SKY = new BiomeType("sky", "Sky");
    public static final BiomeType FLOWER = new BiomeType("flower", "Flowers");
    public static final BiomeType LAKE = new BiomeType("lake", "Lake");
    public static final BiomeType INDUSTRIAL = new BiomeType("industrial", "Industrial Area");
    public static final BiomeType METEOR = new BiomeType("meteor", "Meteor Area");
    public static final BiomeType RUIN = new BiomeType("ruin", "Ruins");
    public static final BiomeType CAVE = new BiomeType("cave", "Cave");
    public static final BiomeType CAVE_WATER = new BiomeType("cavewater", "Cave Lake");
    public static final BiomeType VILLAGE = new BiomeType("village", "Village");
    public static final BiomeType ALL = new BiomeType("all", "All");
    public final String name;
    private final ResourceLocation key;
    public final String readableName;
    public final RegistryDelegate<BiomeType> delegate = PersistentRegistryManager.makeDelegate((IForgeRegistryEntry)this, BiomeType.class);

    public static BiomeType getBiome(String name) {
        return BiomeType.getBiome(name, true);
    }

    public static BiomeType getBiome(String name, boolean generate) {
        for (BiomeType b : BiomeType.values()) {
            if (!b.name.equalsIgnoreCase(name) && !b.readableName.equalsIgnoreCase(name)) continue;
            return b;
        }
        if (generate) {
            BiomeType ret = new BiomeType(name.toLowerCase(), name);
            return ret;
        }
        return NONE;
    }

    public static ArrayList<BiomeType> values() {
        return values;
    }

    private BiomeType(String name, String readableName) {
        this.name = name;
        this.readableName = readableName;
        this.key = new ResourceLocation("thutcore", name);
        values.add(this);
        BiomeDatabase.biomeTypeRegistry.register(-1, this.key, (IForgeRegistryEntry)this);
    }

    public int getType() {
        return BiomeDatabase.biomeTypeRegistry.getId((IForgeRegistryEntry)this);
    }
}

