/*
 * Decompiled with CFR 0.152.
 */
package thut.api.pathing;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import thut.api.maths.Matrix3;
import thut.api.maths.Vector3;
import thut.api.pathing.IPathFinder;
import thut.api.pathing.IPathingMob;
import thut.api.pathing.PathPoint;
import thut.api.pathing.ThutPath;

public class ThutPathFinder
extends PathFinder
implements IPathFinder {
    static double max = 0.0;
    static int count = 0;
    static double mean = 0.0;
    protected final IBlockAccess worldMap;
    protected final ThutPath pathf = new ThutPath();
    protected final ThutPath pathb = new ThutPath();
    protected final IntHashMap<PathPoint> pointMap = new IntHashMap();
    protected final PathPoint[] pathOptionsf = new PathPoint[64];
    protected final PathPoint[] pathOptionsb = new PathPoint[64];
    protected final IPathingMob mob;
    protected final List<AxisAlignedBB> aabbs = Lists.newArrayList();
    protected int PATHTIME = 5000000;
    protected final Matrix3 box = new Matrix3();
    Vector3 v0 = Vector3.getNewVector();
    Vector3 v1 = Vector3.getNewVector();

    public static Vector3 getOpposite(EnumFacing side, Vector3 ret) {
        switch (side) {
            case UP: {
                return ret.set(EnumFacing.DOWN);
            }
            case DOWN: {
                return ret.set(EnumFacing.UP);
            }
            case EAST: {
                return ret.set(EnumFacing.WEST);
            }
            case WEST: {
                return ret.set(EnumFacing.EAST);
            }
            case NORTH: {
                return ret.set(EnumFacing.SOUTH);
            }
            case SOUTH: {
                return ret.set(EnumFacing.NORTH);
            }
        }
        return ret.set(side);
    }

    public ThutPathFinder(IBlockAccess world, IPathingMob entity) {
        super(null);
        this.worldMap = world;
        this.mob = entity;
    }

    protected Path addToPath(Entity entity, PathPoint start, PathPoint end, float distance) {
        if (end.equals((Object)start)) {
            return null;
        }
        start.field_75836_e = 0.0f;
        start.field_75834_g = start.field_75833_f = start.distanceToSquared(end);
        this.pathf.clearPath();
        this.pathb.clearPath();
        this.pathf.addPoint(start);
        this.pathb.addPoint(end);
        long starttime = System.nanoTime();
        this.PATHTIME = this.mob.getPathTime();
        Vector3 size = Vector3.getNewVector();
        size.set(this.mob.getMobSizes());
        PathPoint pathpoint3 = this.getSubPath(size, start, end, this.pathf, distance);
        double dt = (double)(System.nanoTime() - starttime) / 1000000.0;
        max = Math.max(dt, max);
        mean = (mean * (double)(++count - 1) + dt) / (double)count;
        if (pathpoint3 == start || pathpoint3 == null) {
            return null;
        }
        if (pathpoint3 == start) {
            return null;
        }
        return this.createEntityPath(pathpoint3);
    }

    private boolean canFit(Vector3 e, IBlockState b) {
        return false;
    }

    private Path createEntityPath(PathPoint end) {
        int i = 1;
        PathPoint pathpoint2 = end;
        pathpoint2 = end;
        while (pathpoint2.field_75841_h != null) {
            ++i;
            pathpoint2 = pathpoint2.field_75841_h;
        }
        net.minecraft.pathfinding.PathPoint[] apathpoint = new PathPoint[i];
        pathpoint2 = end;
        apathpoint[--i] = end;
        while (pathpoint2.field_75841_h != null) {
            pathpoint2 = pathpoint2.field_75841_h;
            apathpoint[--i] = pathpoint2;
        }
        return new Path(apathpoint);
    }

    private Path createEntityPathTo(double x, double y, double z, float distance) {
        Entity entity = (Entity)this.mob;
        this.pathb.clearPath();
        this.pathf.clearPath();
        this.pointMap.func_76046_c();
        int i = MathHelper.func_76128_c((double)(entity.func_174813_aQ().field_72338_b + 0.5));
        double dist = entity.func_70011_f(x, y, z);
        dist = Math.max(2.0 * dist, (double)(2.0f * distance));
        if (!this.mob.swims() && entity.func_70090_H()) {
            i = (int)entity.func_174813_aQ().field_72338_b;
            Block block = this.worldMap.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), i, MathHelper.func_76128_c((double)entity.field_70161_v))).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                block = this.worldMap.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), ++i, MathHelper.func_76128_c((double)entity.field_70161_v))).func_177230_c();
            }
        }
        if (this.mob.flys()) {
            y += 1.0;
        } else if (this.mob.floats()) {
            y += this.mob.getFloatHeight();
        }
        PathPoint start = this.openPoint(MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72340_a), i, MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72339_c));
        PathPoint end = this.openPoint(MathHelper.func_76128_c((double)(x - (double)(entity.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)(z - (double)(entity.field_70130_N / 2.0f))));
        Path path = this.addToPath(entity, start, end, distance);
        return path;
    }

    public Path createEntityPathTo(Entity entity, int x, int y, int z, float distance) {
        return this.createEntityPathTo((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, distance);
    }

    @Override
    public Path createEntityPathTo(IBlockAccess blockaccess, Entity entityIn, BlockPos targetPos, float dist) {
        return this.createEntityPathTo(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), dist);
    }

    @Override
    public Path createEntityPathTo(IBlockAccess world, Entity entity, Entity target, float distance) {
        return this.createEntityPathTo(target.field_70165_t, target.func_174813_aQ().field_72338_b + 0.5, target.field_70161_v, distance);
    }

    protected int findOptions(Vector3 pokemob, PathPoint current, PathPoint end, PathPoint[] pathOptions) {
        int ret = 0;
        int scale = 1;
        Vector3 check = Vector3.getNewVector();
        for (int l = 0; l < scale; ++l) {
            if (ret > pathOptions.length - 10) {
                return ret;
            }
            int dx = end.field_75839_a - current.field_75839_a;
            int dy = end.field_75837_b - current.field_75837_b;
            int dz = end.field_75838_c - current.field_75838_c;
            EnumFacing s = null;
            if (dx != 0 && dx > dy && dx > dz) {
                s = dx < 0 ? EnumFacing.EAST : EnumFacing.WEST;
            } else if (dy != 0 && dy > dz && dy > dx) {
                s = dy < 0 ? EnumFacing.UP : EnumFacing.DOWN;
            } else if (dz != 0 && dz > dx && dz > dy) {
                s = dz < 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            int num = s != null ? s.ordinal() : 0;
            for (int i = 0; i < 6; ++i) {
                float f1;
                IBlockState down;
                PathPoint point1;
                EnumFacing side = EnumFacing.values()[(i + num) % 6];
                if (side == this.getDirFromPoint(current)) continue;
                int x = current.field_75839_a + side.func_82601_c() * (l + 1);
                int y = current.field_75837_b + side.func_96559_d() * (l + 1);
                int z = current.field_75838_c + side.func_82599_e() * (l + 1);
                boolean safe = false;
                PathPoint point = this.openPoint(x, y, z);
                if (this.isSafe(pokemob, x, y, z, ThutPathFinder.getOpposite(side, check))) {
                    point1 = this.openPoint(x, y - 1, z);
                    if (!point.isFirst) {
                        down = this.v0.set((Object)point1).getBlockState(this.worldMap);
                        this.v1.set((Object)point1);
                        f1 = this.mob.getBlockPathWeight(this.worldMap, this.v1.offsetBy(EnumFacing.DOWN));
                        if (down.func_185904_a().func_76224_d()) {
                            if (!point1.isFirst) {
                                point1.blockWeight = f1;
                                pathOptions[ret++] = point1;
                                safe = true;
                            }
                        } else if (!point.isFirst) {
                            point.blockWeight = f1;
                            pathOptions[ret++] = point;
                            safe = true;
                        }
                    }
                }
                if (safe || side == EnumFacing.DOWN || side == EnumFacing.UP) continue;
                if (this.isSafe(pokemob, x, y + 1, z, ThutPathFinder.getOpposite(side, check))) {
                    point1 = this.openPoint(x, y + 1, z);
                    if (!point.isFirst) {
                        down = this.v0.set((Object)point1).getBlockState(this.worldMap);
                        this.v1.set((Object)point1);
                        f1 = this.mob.getBlockPathWeight(this.worldMap, this.v1.offsetBy(EnumFacing.DOWN));
                        if (down.func_185904_a().func_76224_d()) {
                            if (!point.isFirst) {
                                point.blockWeight = f1 + 5.0f;
                                pathOptions[ret++] = point;
                                safe = true;
                            }
                        } else if (!point1.isFirst) {
                            point1.blockWeight = f1 + 5.0f;
                            pathOptions[ret++] = point1;
                            safe = true;
                        }
                    }
                }
                if (!this.isSafe(pokemob, x, y - 1, z, ThutPathFinder.getOpposite(side, check))) continue;
                point = this.openPoint(x, y - 1, z);
                point1 = this.openPoint(x, y - 2, z);
                if (point.isFirst) continue;
                down = this.v0.set((Object)point1).getBlockState(this.worldMap);
                this.v1.set((Object)point1);
                f1 = this.mob.getBlockPathWeight(this.worldMap, this.v1.offsetBy(EnumFacing.DOWN));
                if (down.func_185904_a().func_76224_d()) {
                    if (point1.isFirst) continue;
                    point1.blockWeight = f1 + 5.0f;
                    pathOptions[ret++] = point1;
                    safe = true;
                    continue;
                }
                if (point.isFirst) continue;
                point.blockWeight = f1 + 5.0f;
                pathOptions[ret++] = point;
                safe = true;
            }
        }
        return ret;
    }

    EnumFacing getDirFromPoint(PathPoint current) {
        EnumFacing side = null;
        if (current.field_75841_h == null) {
            return side;
        }
        int dx = current.field_75839_a - current.field_75841_h.field_75839_a;
        int dy = current.field_75837_b - current.field_75841_h.field_75837_b;
        int dz = current.field_75838_c - current.field_75841_h.field_75838_c;
        if (dx != 0 && dx > dy && dx >= dz) {
            return dx < 0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (dy != 0 && dy > dz && dy >= dx) {
            return dy < 0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (dz != 0 && dz > dx && dz >= dy) {
            return dz < 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return side;
    }

    PathPoint getPoint(Vector3 pokemob, PathPoint[] pathpoint, PathPoint start, PathPoint end, ThutPath path, PathPoint[] pathOptions, boolean forward) {
        PathPoint pathpoint4 = path.dequeue();
        PathPoint pathpoint3 = pathpoint[2];
        byte dir = (byte)(forward ? 1 : -1);
        if (pathpoint4.equals((Object)end)) {
            return pathpoint4;
        }
        pathpoint4.isFirst = true;
        int i = this.findOptions(pokemob, pathpoint4, end, pathOptions);
        for (int j = 0; j < i; ++j) {
            PathPoint pathpoint5 = pathOptions[j];
            if (pathpoint5.equals((Object)end)) {
                pathpoint5.field_75841_h = pathpoint4;
                return pathpoint5;
            }
            if (pathpoint5.direction != 0 && pathpoint5.direction != dir) {
                pathpoint[1] = pathpoint5;
                return pathpoint4;
            }
            pathpoint5.direction = dir;
            float newPathDistance = pathpoint4.field_75836_e + pathpoint4.distanceToSquared(pathpoint5) + pathpoint5.blockWeight;
            if (!pathpoint5.func_75831_a() || newPathDistance < pathpoint5.field_75836_e) {
                pathpoint5.field_75841_h = pathpoint4;
                pathpoint5.field_75836_e = newPathDistance;
                pathpoint5.field_75833_f = pathpoint5.distanceToSquared(end);
                if (pathpoint5.func_75831_a()) {
                    path.changeDistance(pathpoint5, pathpoint5.field_75836_e + pathpoint5.field_75833_f + pathpoint5.blockWeight);
                } else {
                    pathpoint5.field_75834_g = pathpoint5.field_75836_e + pathpoint5.field_75833_f + pathpoint5.blockWeight;
                    path.addPoint(pathpoint5);
                }
            }
            if (pathpoint3 != null) {
                float f = pathpoint3.distanceToSquared(forward ? end : start);
                PathPoint pathPoint = forward ? end : start;
                if (!(f > pathpoint5.distanceToSquared(pathPoint))) continue;
            }
            pathpoint3 = pathpoint[2] = pathpoint5;
        }
        return null;
    }

    protected PathPoint getSubPath(Vector3 pokemob, PathPoint start, PathPoint end, ThutPath path, float distance) {
        long time;
        PathPoint[] pointf = new PathPoint[]{start, null, null};
        PathPoint[] pointb = new PathPoint[]{end, null, null};
        PathPoint p1 = null;
        PathPoint p2 = null;
        PathPoint p3 = null;
        int p3t = 0;
        long starttime = System.nanoTime();
        int tries = 0;
        do {
            if (pointf[2] != null) {
                if (p3 == null) {
                    p3 = pointf[2];
                    p3t = tries;
                }
                if (p3 != pointf[2]) {
                    p3 = pointf[2];
                    p3t = tries;
                }
            }
            if (!this.pathf.isPathEmpty() && p2 == null) {
                p1 = this.getPoint(pokemob, pointf, start, end, this.pathf, this.pathOptionsf, true);
            }
            if (pointf[0].equals((Object)end)) {
                return pointf[0];
            }
            if (!this.pathb.isPathEmpty() && p1 == null) {
                p2 = this.getPoint(pokemob, pointb, end, start, this.pathb, this.pathOptionsb, false);
            }
            if (pointb[0].equals((Object)start)) {
                return PathPoint.merge(null, pointb[0]);
            }
            if (this.pathf.isPathEmpty() && this.pathb.isPathEmpty()) {
                return null;
            }
            if (pointf[1] != null && p1 != null && p2 == null) {
                p2 = pointf[1];
            }
            if (pointb[1] != null && p2 != null && p1 == null) {
                p1 = pointb[1];
            }
            ++tries;
            if (p1 == null || p2 == null) continue;
            return PathPoint.merge(p1, p2);
        } while (!((time = System.nanoTime() - starttime) > (long)this.PATHTIME || (double)tries > 2.5 * (double)p3t && p3t > 200) && tries <= 1000);
        return pointf[2];
    }

    private boolean isEmpty(Vector3 e, int x, int y, int z, Vector3 from) {
        Vector3 v = this.v0.set((double)x + 0.5, y, (double)z + 0.5);
        boolean clear = false;
        IBlockState state = v.getBlockState(this.worldMap);
        Block b = state.func_177230_c();
        if (this.mob.getBlockPathWeight(this.worldMap, e) < 0.0f) {
            return false;
        }
        if (b instanceof BlockDoor && state.func_185904_a() == Material.field_151575_d) {
            return this.canFit(e, state);
        }
        if (state.func_185904_a() == Material.field_151587_i) {
            return false;
        }
        if (state.func_185915_l() || state.func_185904_a().func_76230_c()) {
            return false;
        }
        if (b.isLadder(state, this.worldMap, v.getPos(), (EntityLivingBase)this.mob)) {
            return true;
        }
        if (e.x > 1.0 || e.z > 1.0) {
            clear = this.mob.fits(this.worldMap, v, from);
            return clear;
        }
        clear = v.clearOfBlocks(this.worldMap) || v.add(0.0, ((EntityLiving)this.mob).field_70138_W, 0.0).isClearOfBlocks(this.worldMap);
        if (!clear) {
            return false;
        }
        return clear;
    }

    protected boolean isSafe(Vector3 e, int x, int y, int z, Vector3 from) {
        IBlockState state = this.worldMap.func_180495_p(new BlockPos(x, y - 1, z));
        Material mDown = state.func_185904_a();
        boolean water = this.mob.swims();
        boolean air = this.mob.flys() || this.mob.floats();
        BlockPos pos = new BlockPos(x, y, z);
        state = this.worldMap.func_180495_p(pos);
        boolean ladder = state.func_177230_c().isLadder(state, this.worldMap, pos, (EntityLivingBase)this.mob);
        if (air || ladder) {
            return this.isEmpty(e, x, y, z, from);
        }
        if (water) {
            if (!mDown.func_76220_a() && mDown != Material.field_151586_h) {
                return false;
            }
            boolean empty = this.isEmpty(e, x, y, z, from);
            return empty;
        }
        if (mDown.func_76224_d() && mDown != Material.field_151586_h) {
            return false;
        }
        return this.isEmpty(e, x, y, z, from) && (mDown == Material.field_151586_h || !this.isEmpty(e, x, y - 1, z, from));
    }

    protected final PathPoint openPoint(int x, int y, int z) {
        int l = PathPoint.makeHash(x, y, z);
        PathPoint pathpoint = (PathPoint)((Object)this.pointMap.func_76041_a(l));
        if (pathpoint == null) {
            pathpoint = new PathPoint(x, y, z);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }
}

