/*
 * Decompiled with CFR 0.152.
 */
package thut.api.pathing;

import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.Path;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thut.api.maths.Vector3;
import thut.api.pathing.IPathingMob;
import thut.api.pathing.JPSPather;

public class Paths {
    public final World world;
    public ChunkCache chunks;
    public Vector3 lastSite = Vector3.getNewVector();
    Vector3 v = Vector3.getNewVector();
    public long lastTime = 0L;
    public final boolean[] cacheLock = new boolean[]{false, false};

    public Paths(World world) {
        this.world = world;
    }

    public Path getEntityPathToXYZ(Entity entity, int x, int y, int z, float distance) {
        while (this.cacheLock[0]) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.chunks == null) {
            return null;
        }
        this.cacheLock[1] = true;
        JPSPather pather = new JPSPather((IBlockAccess)this.chunks, (IPathingMob)entity);
        Path path = pather.createEntityPathTo(entity, x, y, z, distance);
        this.cacheLock[1] = false;
        return path;
    }

    public Path getPathHeapToEntity(Entity entityA, Entity entityB, float distance) {
        while (this.cacheLock[0]) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.chunks == null) {
            return null;
        }
        this.cacheLock[1] = true;
        Path path = new JPSPather((IBlockAccess)this.chunks, (IPathingMob)entityA).createEntityPathTo((IBlockAccess)this.chunks, entityA, entityB, distance);
        this.cacheLock[1] = false;
        return path;
    }
}

