/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thut.api.TickHandler;
import thut.api.WorldCache;
import thut.api.maths.Cruncher;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;

public class ExplosionCustom
extends Explosion {
    public static int MAX_RADIUS = 127;
    public static Block melt;
    public static Block solidmelt;
    public static Block dust;
    static final boolean[] toClear;
    static final ExplosionCustom instance;
    public static final Vector<ExplosionStuff> explosions;
    public static final ConcurrentHashMap<Integer, Vector<Entity>> worldEntities;
    private static int maxThreads;
    private static final Thread boomThread;
    IBlockAccess field_77287_j;
    int dimension;
    private World world;
    Vector3 centre;
    float strength;
    public boolean meteor = false;
    public EntityPlayer owner = null;
    List<Entity> targets = new ArrayList<Entity>();
    private double explosionX;
    private double explosionY;
    private double explosionZ;
    private float explosionSize;
    private boolean isSmoking = false;
    Entity field_77283_e;
    public Set<BlockPos> field_77281_g = new HashSet<BlockPos>();
    Map<EntityLivingBase, Float> damages = new HashMap<EntityLivingBase, Float>();
    List<Chunk> affected = new ArrayList<Chunk>();

    public ExplosionCustom(World world, Entity par2Entity, double x, double y, double z, float power) {
        super(world, par2Entity, x, y, z, power, false, false);
        this.field_77283_e = par2Entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = power;
        this.world = world;
        this.dimension = world.field_73011_w.getDimension();
        this.strength = power;
        this.centre = Vector3.getNewVector().set(x, y, z);
        this.field_77287_j = TickHandler.getInstance().getWorldCache(this.dimension);
    }

    public ExplosionCustom(World world, Entity par2Entity, Vector3 center, float power) {
        super(world, par2Entity, center.x, center.y, center.z, power, false, false);
        this.world = world;
        this.field_77283_e = par2Entity;
        this.strength = power;
        this.explosionX = center.x;
        this.explosionY = center.y;
        this.explosionZ = center.z;
        this.explosionSize = power;
        this.centre = center.copy();
        if (!toClear[1]) {
            ExplosionCustom.toClear[1] = true;
        }
        if (world == null) {
            return;
        }
        this.dimension = world.field_73011_w.getDimension();
        this.field_77287_j = TickHandler.getInstance().getWorldCache(this.dimension);
    }

    public void addChunkPosition(Vector3 v) {
        this.field_77281_g.add(new BlockPos(v.intX(), v.intY(), v.intZ()));
    }

    public boolean canBreak(Vector3 location) {
        boolean ret = true;
        if (this.owner != null) {
            try {
                BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(this.world, location.getPos(), location.getBlockState((IBlockAccess)this.world), this.owner);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (evt.isCanceled()) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return ret;
    }

    public void doExplosion() {
        this.world.func_184148_a((EntityPlayer)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        }
        explosions.addElement(new ExplosionStuff(this, MAX_RADIUS, this.strength, this.field_77287_j, this.centre));
    }

    public void func_77278_a() {
        this.field_77281_g.clear();
        System.err.println("This should not be run anymore");
        new Exception().printStackTrace();
    }

    public void func_77279_a(boolean par1) {
    }

    public void doKineticImpactor(World worldObj, Vector3 velocity, Vector3 hitLocation, Vector3 acceleration, float density, float energy) {
        if (density < 0.0f || energy <= 0.0f) {
            return;
        }
        int max = 63;
        this.field_77281_g.clear();
        if (acceleration == null) {
            acceleration = Vector3.empty;
        }
        float factor = 1.0f;
        int n = 0;
        ArrayList<Vector3> locations = new ArrayList<Vector3>();
        ArrayList<Float> blasts = new ArrayList<Float>();
        float resist = hitLocation.getExplosionResistance(this, (IBlockAccess)worldObj);
        float blast = Math.min(energy * (resist / density), energy);
        if (resist > density) {
            hitLocation = hitLocation.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, hitLocation, blast * factor);
            boo.doExplosion();
            return;
        }
        Vector3 absorbedLoc = Vector3.getNewVector();
        float remainingEnergy = 0.0f;
        density -= resist;
        while (energy > 0.0f && density > 0.0f) {
            locations.add(hitLocation.subtract(velocity.normalize()));
            blasts.add(Float.valueOf(blast));
            hitLocation = hitLocation.add(velocity.normalize());
            velocity.add(acceleration);
            resist = Math.max(hitLocation.getExplosionResistance(this, (IBlockAccess)worldObj), 0.0f);
            blast = Math.min(energy * (resist / density), energy);
            if (resist > density) {
                absorbedLoc.set(hitLocation);
                remainingEnergy = energy;
                break;
            }
            energy -= energy * (resist / density);
            density = (float)((double)density - ((double)resist + 0.1));
        }
        if ((n = locations.size()) != 0) {
            for (int i = 0; i < n; ++i) {
                Vector3 source = (Vector3)locations.get(i);
                float strength = Math.min(((Float)blasts.get(i)).floatValue(), 256.0f);
                if (!worldObj.func_175697_a(source.getPos(), max) || strength == 0.0f) continue;
                ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, source, strength * factor);
                boo.doExplosion();
            }
        }
        if (remainingEnergy > 10.0f) {
            absorbedLoc = absorbedLoc.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, absorbedLoc, remainingEnergy * factor);
            System.out.println("radius: " + max + " " + absorbedLoc);
            boo.doExplosion();
        }
    }

    public void doMeteorStuff(Block destroyed, Vector3 location) {
        if (!this.meteor) {
            TickHandler.BlockChange change = new TickHandler.BlockChange(location, this.dimension, Blocks.field_150350_a);
            change.flag = 2;
            TickHandler.addBlockChange(change, this.dimension);
            return;
        }
        float resistance = location.getExplosionResistance(this, this.field_77287_j);
        if (melt == null) {
            melt = Blocks.field_150350_a;
        }
        if (dust == null) {
            dust = Blocks.field_150350_a;
        }
        if (resistance > 2.0f && !location.getBlockMaterial(this.field_77287_j).func_76224_d()) {
            int meta = (int)Math.min(resistance / 2.0f, 15.0f);
            TickHandler.BlockChange change = new TickHandler.BlockChange(location, this.dimension, melt, meta);
            change.flag = 2;
            TickHandler.addBlockChange(change, this.dimension);
        } else {
            TickHandler.BlockChange change = new TickHandler.BlockChange(location, this.dimension, dust);
            change.flag = 2;
            TickHandler.addBlockChange(change, this.dimension);
        }
    }

    HashMap<Integer, List<Entity>> getEntitiesInRange(int distance) {
        HashMap<Integer, List<Entity>> ret = new HashMap<Integer, List<Entity>>();
        List<Object> ents = this.getEntitiesWithinDistance(this.centre, Entity.class, distance, this.dimension);
        for (Object o : ents) {
            List<Object> temp;
            int z;
            int y;
            Entity e = (Entity)o;
            if (this.centre.distToEntity(e) > (double)distance) continue;
            int x = MathHelper.func_76128_c((double)(e.field_70165_t - this.centre.x));
            int key = Cruncher.getVectorInt(x, y = MathHelper.func_76128_c((double)(e.field_70163_u - this.centre.y)), z = MathHelper.func_76128_c((double)(e.field_70161_v - this.centre.z)));
            if (ret.containsKey(key)) {
                temp = ret.get(key);
            } else {
                temp = new ArrayList();
                ret.put(key, temp);
            }
            temp.add(e);
        }
        return ret;
    }

    List<Object> getEntitiesWithinDistance(Vector3 centre, Class<Entity> targetClass, int distance, int dimension) {
        Vector<Entity> entities = worldEntities.get(dimension);
        ArrayList<Object> list = new ArrayList<Object>();
        double dsq = distance * distance;
        Vector3 point = Vector3.getNewVector();
        if (entities != null) {
            ArrayList<Entity> temp = new ArrayList<Entity>(entities);
            for (Object e : temp) {
                if (!targetClass.isInstance(e)) continue;
                point.set(e);
                if (!(point.distToSq(centre) < dsq)) continue;
                list.add(e);
            }
        }
        return list;
    }

    List<Integer> getRemovedBlocks(double radius, double strength, IBlockAccess worldObj, Vector3 centre) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        ExplosionCustom boom = this;
        Vector3 r = Vector3.getNewVector();
        Vector3 rAbs = Vector3.getNewVector();
        Vector3 rHat = Vector3.getNewVector();
        Vector3 rTest = Vector3.getNewVector();
        Vector3 rTestPrev = Vector3.getNewVector();
        Vector3 rTestAbs = Vector3.getNewVector();
        double scaleFactor = 1500.0;
        double radSq = radius * radius;
        HashMap<Integer, Float> resists = new HashMap<Integer, Float>();
        HashSet<Integer> blockedSet = new HashSet<Integer>();
        BitSet checked = new BitSet();
        int num = (int)Math.sqrt(strength * 1500.0 / 0.5);
        int max = MAX_RADIUS * 2;
        num = Math.min(num, max);
        num = Math.min(num, 1000);
        radSq = num * num / 4;
        HashMap<Integer, List<Entity>> victims = this.getEntitiesInRange(num / 2);
        ArrayList<Integer> affectedThisRadius = new ArrayList<Integer>();
        for (int i = 0; i < num * num * num; ++i) {
            double rSq;
            Cruncher.indexToVals(i, r);
            if ((i > 0 && i < 27 || affectedThisRadius.size() > 100) && !affectedThisRadius.isEmpty()) {
                ClientUpdateInfo info = new ClientUpdateInfo(affectedThisRadius, centre, this.dimension);
                ExplosionVictimTicker.clientUpdates.addElement(info);
                affectedThisRadius.clear();
            }
            if (r.y + centre.y < 0.0 || r.y + centre.y > 255.0 || (rSq = r.magSq()) > radSq) continue;
            double rMag = Math.sqrt(rSq);
            rAbs.set(r).addTo(centre);
            rHat.set(r.normalize());
            int index = Cruncher.getVectorInt(rHat.scalarMultBy(num / 2));
            rHat.scalarMultBy(1.0 / (double)(num / 2));
            if (blockedSet.contains(index)) continue;
            double str = strength * 1500.0 / rSq;
            int index2 = Cruncher.getVectorInt(r);
            if (rAbs.isAir(worldObj) && !r.isEmpty()) {
                if (victims.containsKey(index2)) {
                    for (Entity e : (List)victims.get(index2)) {
                        ExplosionVictimTicker.addVictim(e, (float)str, boom);
                    }
                }
                if (!(rMag < 5.0)) continue;
                affectedThisRadius.add(Cruncher.getVectorInt(r));
                continue;
            }
            if (str <= 0.1) {
                System.out.println("Terminating at distance " + rMag);
                break;
            }
            if (!this.canBreak(rAbs)) {
                blockedSet.add(index);
                continue;
            }
            float res = rAbs.getExplosionResistance(boom, worldObj);
            if (res > 1.0f) {
                res *= res;
            }
            resists.put(index2, Float.valueOf(res));
            checked.set(index2);
            if ((double)res > str) {
                blockedSet.add(index);
                continue;
            }
            boolean stop = false;
            rMag = r.mag();
            float dj = 1.0f;
            float resist = 0.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest.set(rHat).scalarMultBy(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs.set(rTest).addTo(centre);
                    index2 = Cruncher.getVectorInt(rTest);
                    if (checked.get(index2)) {
                        res = ((Float)resists.get(index2)).floatValue();
                    } else {
                        res = rTestAbs.getExplosionResistance(boom, worldObj);
                        if (res > 1.0f) {
                            res *= res;
                        }
                    }
                    resist += res;
                    if (!this.canBreak(rTestAbs)) {
                        stop = true;
                        blockedSet.add(index);
                        break;
                    }
                    double d1 = rTest.magSq();
                    double d = d1;
                    str = strength * 1500.0 / d;
                    if ((double)resist > str) {
                        stop = true;
                        blockedSet.add(index);
                        break;
                    }
                }
                rTestPrev.set(rTest);
                j += dj;
            }
            if (stop) continue;
            rAbs.set(r).addTo(centre);
            Chunk chunk = ((WorldCache)worldObj).getChunk(rAbs.intX() >> 4, rAbs.intZ() >> 4);
            if (chunk == null) {
                System.out.println("No chunk at " + rAbs);
                Thread.dumpStack();
            }
            if (!this.affected.contains(chunk)) {
                this.affected.add(chunk);
            }
            Block block = rAbs.getBlock(worldObj);
            this.addChunkPosition(rAbs);
            this.doMeteorStuff(block, rAbs);
            str = strength * 1500.0 / rSq;
            index2 = Cruncher.getVectorInt(r);
            if (victims.containsKey(index2)) {
                for (Entity e : (List)victims.get(index2)) {
                    ExplosionVictimTicker.addVictim(e, (float)str, boom);
                }
            }
            affectedThisRadius.add(Cruncher.getVectorInt(r));
        }
        this.func_77279_a(false);
        ExplosionEvent.Detonate evt = new ExplosionEvent.Detonate(boom.world, (Explosion)boom, new ArrayList());
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return toRemove;
    }

    public ExplosionCustom setMeteor(boolean meteor) {
        this.meteor = meteor;
        return this;
    }

    static {
        toClear = new boolean[]{false, false};
        instance = new ExplosionCustom(null, null, Vector3.getNewVector(), 0.0f);
        explosions = new Vector();
        worldEntities = new ConcurrentHashMap();
        maxThreads = -1;
        boomThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    boolean boomed = false;
                    if (explosions.size() > 0) {
                        if (maxThreads == -1) {
                            maxThreads = Runtime.getRuntime().availableProcessors() / 2;
                            maxThreads = Math.max(1, maxThreads);
                        }
                        int num = maxThreads;
                        ArrayList<ExplosionStuff> booms = new ArrayList<ExplosionStuff>(explosions);
                        num = Math.min(num, booms.size());
                        HashSet<ExplosionStuff> toRemove = new HashSet<ExplosionStuff>();
                        for (int i = 0; i < num; ++i) {
                            ExplosionStuff boom = booms.get(i);
                            if (boom.lock[0]) {
                                boom.doBoom();
                            } else if (!boom.lock[1]) {
                                toRemove.add(boom);
                            }
                            boomed = true;
                        }
                        explosions.removeAll(toRemove);
                    }
                    if (toClear[0]) {
                        explosions.clear();
                        ExplosionCustom.toClear[0] = false;
                    }
                    if (boomed) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        boomThread.setName("explosionThread");
        System.out.println("Starting explosion thread");
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionVictimTicker());
        boomThread.start();
    }

    public static class VictimStuff {
        final int entity;
        final int dimension;
        final float damage;
        final Explosion explosion;

        public VictimStuff(Entity hit, float d, Explosion e) {
            this.entity = hit.func_145782_y();
            this.dimension = hit.field_71093_bK;
            this.damage = d;
            this.explosion = e;
        }

        public VictimStuff(int id, int dim, float d, Explosion e) {
            this.entity = id;
            this.dimension = dim;
            this.damage = d;
            this.explosion = e;
        }

        public boolean equals(Object o) {
            if (o instanceof VictimStuff) {
                return ((VictimStuff)o).entity == this.entity;
            }
            return super.equals(o);
        }
    }

    public static class ExplosionVictimTicker {
        public static Vector<VictimStuff> victims = new Vector();
        public static Vector<ClientUpdateInfo> clientUpdates = new Vector();
        private static HashSet<Object> toRemove = new HashSet();

        public static void addVictim(Entity victim, float damage, Explosion blast) {
            VictimStuff v = new VictimStuff(victim, damage, blast);
            victims.add(v);
        }

        public static void applyDamage(VictimStuff v) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(v.dimension);
            Entity hit = world.func_73045_a(v.entity);
            if (hit != null && !hit.field_70128_L) {
                hit.func_70097_a(DamageSource.func_94539_a((Explosion)v.explosion), v.damage);
            }
        }

        @SubscribeEvent
        public void tick(TickEvent.WorldTickEvent evt) {
            if (evt.phase == TickEvent.Phase.END) {
                ArrayList<Object> temp;
                if (clientUpdates.size() > 0) {
                    temp = new ArrayList<ClientUpdateInfo>(clientUpdates);
                    for (ClientUpdateInfo clientUpdateInfo : temp) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74783_a("mid", clientUpdateInfo.centre);
                        nbt.func_74783_a("affected", clientUpdateInfo.affectedBlocks);
                        PacketHandler.MessageClient message = new PacketHandler.MessageClient(1, nbt);
                        PacketHandler.packetPipeline.sendToDimension((IMessage)message, clientUpdateInfo.dim);
                        toRemove.add(clientUpdateInfo);
                    }
                    clientUpdates.removeAll(toRemove);
                    toRemove.clear();
                }
                if (victims.size() > 0) {
                    temp = new ArrayList<VictimStuff>(victims);
                    for (VictimStuff victimStuff : temp) {
                        ExplosionVictimTicker.applyDamage(victimStuff);
                        toRemove.add(victimStuff);
                    }
                    victims.removeAll(toRemove);
                    toRemove.clear();
                }
            } else {
                Vector<Object> entities = worldEntities.get(evt.world.field_73011_w.getDimension());
                if (entities == null) {
                    entities = new Vector();
                }
                entities.clear();
                entities.addAll(evt.world.field_72996_f);
                worldEntities.put(evt.world.field_73011_w.getDimension(), entities);
            }
        }
    }

    public static class ExplosionStuff {
        final ExplosionCustom boom;
        final double radius;
        final double strength;
        final IBlockAccess worldObj;
        final Vector3 centre;
        final boolean[] lock = new boolean[]{true, false};

        public ExplosionStuff(ExplosionCustom boom, double radius, double strength, IBlockAccess worldObj, Vector3 centre) {
            this.boom = boom;
            this.radius = radius;
            this.strength = strength;
            this.worldObj = worldObj;
            this.centre = centre;
        }

        public void doBoom() {
            if (this.lock[1]) {
                return;
            }
            this.lock[1] = true;
            Thread newBoom = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExplosionStuff.this.boom.getRemovedBlocks(ExplosionStuff.this.radius, ExplosionStuff.this.strength, ExplosionStuff.this.worldObj, ExplosionStuff.this.centre);
                    ExplosionStuff.this.lock[0] = false;
                    ExplosionStuff.this.lock[1] = false;
                    TickHandler.cleanup();
                }
            });
            newBoom.setPriority(1);
            newBoom.setName(newBoom.getName().replace("Thread", "ExplosionThread"));
            newBoom.start();
        }
    }

    public static class ClientUpdateInfo {
        final int[] affectedBlocks;
        final int dim;
        final int[] centre;

        public ClientUpdateInfo(List<Integer> affected, Vector3 mid, int dim_) {
            this.affectedBlocks = new int[affected.size()];
            for (int i = 0; i < affected.size(); ++i) {
                this.affectedBlocks[i] = affected.get(i);
            }
            this.dim = dim_;
            this.centre = new int[3];
            this.centre[0] = mid.intX();
            this.centre[1] = mid.intY();
            this.centre[2] = mid.intZ();
        }
    }
}

