/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import thut.api.maths.Vector3;

public class Transporter {
    public static Entity teleportEntity(Entity entity, Vector3 t2, int dimension, boolean destBlocked) {
        if (dimension != entity.field_71093_bK) {
            return Transporter.teleportToDimension(entity, t2, dimension, destBlocked);
        }
        if (entity instanceof EntityPlayer) {
            entity.func_70634_a(t2.x, t2.y, t2.z);
            return entity;
        }
        return entity;
    }

    private static Entity teleportToDimension(Entity entity, Vector3 t2, int dimension, boolean destBlocked) {
        int oldDimension = entity.field_70170_p.field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
        MinecraftServer server = ((EntityPlayerMP)entity).field_70170_p.func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        entityPlayerMP.func_82242_a(0);
        worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)new TTeleporter(worldServer, t2.x, t2.y, t2.z));
        entityPlayerMP.func_70634_a(t2.x, t2.y, t2.z);
        if (oldDimension == 1) {
            entityPlayerMP.func_70634_a(t2.x, t2.y, t2.z);
            worldServer.func_72838_d((Entity)entityPlayerMP);
            worldServer.func_72866_a((Entity)entityPlayerMP, false);
        }
        return entityPlayerMP;
    }

    public static class TTeleporter
    extends Teleporter {
        private final WorldServer worldServerInstance;
        private double x;
        private double y;
        private double z;

        public TTeleporter(WorldServer world, double x, double y, double z) {
            super(world);
            this.worldServerInstance = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void func_180266_a(Entity pEntity, float rotationYaw) {
            this.worldServerInstance.func_180495_p(new BlockPos((int)this.x, (int)this.y, (int)this.z));
            pEntity.func_70107_b(this.x, this.y, this.z);
            pEntity.field_70159_w = 0.0;
            pEntity.field_70181_x = 0.0;
            pEntity.field_70179_y = 0.0;
        }
    }

    public static class TelDestination {
        final World dim;
        final double x;
        final double y;
        final double z;
        final Vector3 loc;
        final int xOff;
        final int yOff;
        final int zOff;

        public TelDestination(int dim, Vector3 loc) {
            this((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim), loc.getAABB(), loc.x, loc.y, loc.z, loc.intX(), loc.intY(), loc.intZ());
        }

        public TelDestination(World _dim, AxisAlignedBB srcBox, double _x, double _y, double _z, int tileX, int tileY, int tileZ) {
            this.dim = _dim;
            this.x = Math.min(srcBox.field_72336_d - 0.5, Math.max(srcBox.field_72340_a + 0.5, _x + (double)tileX));
            this.y = Math.min(srcBox.field_72337_e - 0.5, Math.max(srcBox.field_72338_b + 0.5, _y + (double)tileY));
            this.z = Math.min(srcBox.field_72334_f - 0.5, Math.max(srcBox.field_72339_c + 0.5, _z + (double)tileZ));
            this.xOff = tileX;
            this.yOff = tileY;
            this.zOff = tileZ;
            this.loc = Vector3.getNewVector().set(this.x, this.y, this.z);
        }

        public TelDestination(World _dim, Vector3 loc) {
            this(_dim, loc.getAABB(), loc.x, loc.y, loc.z, loc.intX(), loc.intY(), loc.intZ());
        }
    }
}

