/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class WorldCache
implements IBlockAccess {
    public final World world;
    private final Long2ObjectMap<ChunkCache> map = new Long2ObjectOpenHashMap();
    final Set<ChunkCache> cache = Sets.newConcurrentHashSet();

    public WorldCache(World world_) {
        this.world = world_;
    }

    void addChunk(Chunk chunk) {
        long key = ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
        ChunkCache chunkcache = new ChunkCache(chunk);
        this.map.put(key, (Object)chunkcache);
        this.cache.add(chunkcache);
    }

    public boolean func_72806_N() {
        return false;
    }

    public Biome func_180494_b(BlockPos pos) {
        return null;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        int i1;
        int l = pos.func_177958_n() >> 4;
        long key = ChunkPos.func_77272_a((int)l, (int)(i1 = pos.func_177952_p() >> 4));
        ChunkCache chunk = (ChunkCache)this.map.get(key);
        if (chunk == null) {
            return null;
        }
        return chunk.getBlockState(pos);
    }

    public Chunk getChunk(int chunkX, int chunkZ) {
        long key = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        ChunkCache chunkcache = (ChunkCache)this.map.get(key);
        if (chunkcache == null) {
            return null;
        }
        return chunkcache.chunk;
    }

    public int func_175626_b(BlockPos pos, int p_175626_2_) {
        return 0;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        int i1;
        int l = pos.func_177958_n() >> 4;
        long key = ChunkPos.func_77272_a((int)l, (int)(i1 = pos.func_177952_p() >> 4));
        ChunkCache chunk = (ChunkCache)this.map.get(key);
        if (chunk == null) {
            return null;
        }
        return chunk.getTileEntity(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
    }

    public WorldType func_175624_G() {
        return this.world.func_72912_H().func_76067_t();
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state == null || state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int i1;
        int l = pos.func_177958_n() >> 4;
        long key = ChunkPos.func_77272_a((int)l, (int)(i1 = pos.func_177952_p() >> 4));
        ChunkCache chunk = (ChunkCache)this.map.get(key);
        if (chunk == null || chunk.isEmpty()) {
            return _default;
        }
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isSideSolid(state, (IBlockAccess)this, pos, side);
    }

    void removeChunk(Chunk chunk) {
        long key = ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
        ChunkCache chunkcache = (ChunkCache)this.map.remove(key);
        if (chunkcache != null) {
            this.cache.remove(chunkcache);
        }
    }

    public static class ChunkCache {
        Chunk chunk;
        private ExtendedBlockStorage[] storageArrays;

        public ChunkCache(Chunk chunk) {
            this.chunk = chunk;
            this.update();
        }

        public IBlockState getBlockState(BlockPos pos) {
            try {
                ExtendedBlockStorage extendedblockstorage;
                if (pos.func_177956_o() >= 0 && pos.func_177956_o() >> 4 < this.storageArrays.length && (extendedblockstorage = this.storageArrays[pos.func_177956_o() >> 4]) != null) {
                    int j = pos.func_177958_n() & 0xF;
                    int k = pos.func_177956_o() & 0xF;
                    int i = pos.func_177952_p() & 0xF;
                    return extendedblockstorage.func_177485_a(j, k, i);
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting block state");
                throw new ReportedException(crashreport);
            }
        }

        public TileEntity getTileEntity(BlockPos pos, Chunk.EnumCreateEntityType immediate) {
            return this.chunk.func_177424_a(pos, immediate);
        }

        public boolean isEmpty() {
            return false;
        }

        public synchronized void update() {
            if (this.storageArrays == null) {
                this.storageArrays = new ExtendedBlockStorage[this.chunk.func_76587_i().length];
            }
            for (int i = 0; i < this.storageArrays.length; ++i) {
                if (this.chunk.func_76587_i()[i] != null) {
                    if (this.storageArrays[i] != null) continue;
                    this.storageArrays[i] = this.chunk.func_76587_i()[i];
                    continue;
                }
                this.storageArrays[i] = null;
            }
        }
    }
}

