/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.util;

import com.teambr.bookshelf.helper.LogHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;

public class VersionChecker
implements Runnable {
    private static String REMOTE_VERSION_XML_FILE;
    private static String lastVersion;
    private static int numRetry;
    private static VersionReturn results;
    private static String modID;
    static Properties remoteVersionProperties;
    static Results result;
    static String remoteVersion;
    static String remoteUpdateLocation;

    public VersionChecker(String xml, String lastVersionIn, int numRetryIn, String modIDIn) {
        REMOTE_VERSION_XML_FILE = xml;
        lastVersion = lastVersionIn;
        numRetry = numRetryIn;
        results = new VersionReturn(null, null, null, null);
        modID = modIDIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkVersion() {
        InputStream remoteVersionRepoStream = null;
        result = Results.UNINITIALIZED;
        try {
            URL remoteVersionURL = new URL(REMOTE_VERSION_XML_FILE);
            remoteVersionRepoStream = remoteVersionURL.openStream();
            remoteVersionProperties.loadFromXML(remoteVersionRepoStream);
            String remoteVersionProperty = remoteVersionProperties.getProperty(Loader.instance().getMCVersionString());
            if (remoteVersionProperty != null) {
                String[] remoteVersionTokens = remoteVersionProperty.split("\\|");
                if (remoteVersionTokens.length >= 2) {
                    remoteVersion = remoteVersionTokens[0];
                    remoteUpdateLocation = remoteVersionTokens[1];
                } else {
                    result = Results.ERROR;
                }
                if (remoteVersion != null) {
                    result = remoteVersion.equalsIgnoreCase(lastVersion) ? Results.CURRENT : Results.OUTDATED;
                }
            } else {
                result = Results.MC_VERSION_NOT_FOUND;
            }
            results = new VersionReturn(lastVersion, remoteVersion, result.name(), remoteUpdateLocation);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == Results.UNINITIALIZED) {
                result = Results.ERROR;
            }
            try {
                if (remoteVersionRepoStream != null) {
                    remoteVersionRepoStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void run() {
        LogHelper.info(I18n.func_74838_a((String)(modID + ".versioncheck.start")));
        try {
            for (int tries = 0; tries < numRetry; ++tries) {
                VersionChecker.checkVersion();
                if (result != Results.ERROR && result != Results.UNINITIALIZED) continue;
                Thread.sleep(10000L);
            }
            if (result == Results.ERROR) {
                result = Results.FINAL_ERROR;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        switch (result) {
            case CURRENT: {
                LogHelper.info(I18n.func_74838_a((String)(modID + ".versioncheck.current")));
                break;
            }
            case OUTDATED: {
                LogHelper.warning(I18n.func_74838_a((String)(modID + ".versioncheck.outdated")));
                break;
            }
            case MC_VERSION_NOT_FOUND: {
                LogHelper.warning(I18n.func_74838_a((String)(modID + ".versioncheck.mcversion")));
                break;
            }
            default: {
                LogHelper.severe(I18n.func_74838_a((String)(modID + ".versioncheck.error")));
            }
        }
    }

    public static VersionReturn getResults() {
        return results;
    }

    static {
        remoteVersionProperties = new Properties();
        result = Results.UNINITIALIZED;
        remoteVersion = null;
        remoteUpdateLocation = null;
    }

    public static class VersionReturn {
        public String oldVersion;
        public String newVersion;
        public String status;
        public String updateLoc;

        public VersionReturn(String oldVersion, String newVersion, String status, String updateLoc) {
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.status = status;
            this.updateLoc = updateLoc;
        }
    }

    public static enum Results {
        UNINITIALIZED,
        CURRENT,
        OUTDATED,
        ERROR,
        FINAL_ERROR,
        MC_VERSION_NOT_FOUND;

    }
}

