/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.util;

import com.teambr.bookshelf.client.shapes.DrawableShape;
import com.teambr.bookshelf.client.shapes.TexturedCylinder;
import com.teambr.bookshelf.client.shapes.TexturedSphere;
import java.awt.Color;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public final class RenderUtils$ {
    public static final RenderUtils$ MODULE$;
    private final ResourceLocation GUI_COMPONENTS;
    private final ResourceLocation MC_BLOCKS;
    private final ResourceLocation MC_ITEMS;
    private final VertexFormat POSITION_TEX_NORMALF;
    private final VertexFormatElement NORMAL_3F;
    private final FloatBuffer matrixBuffer;

    static {
        new RenderUtils$();
    }

    public ResourceLocation GUI_COMPONENTS() {
        return this.GUI_COMPONENTS;
    }

    public ResourceLocation MC_BLOCKS() {
        return this.MC_BLOCKS;
    }

    public ResourceLocation MC_ITEMS() {
        return this.MC_ITEMS;
    }

    public VertexFormat POSITION_TEX_NORMALF() {
        return this.POSITION_TEX_NORMALF;
    }

    public VertexFormatElement NORMAL_3F() {
        return this.NORMAL_3F;
    }

    public void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    public void bindMinecraftItemSheet() {
        this.bindTexture(this.MC_ITEMS());
    }

    public void bindMinecraftBlockSheet() {
        this.bindTexture(this.MC_BLOCKS());
    }

    public void bindGuiComponentsSheet() {
        this.bindTexture(this.GUI_COMPONENTS());
    }

    public void setColor(Color color) {
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
    }

    public void restoreColor() {
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public void prepareRenderState() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3008);
    }

    public void restoreRenderState() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glDisable((int)3008);
    }

    public void renderCubeWithTexture(double x1, double y1, double z1, double x2, double y2, double z2, double u, double v, double u1, double v1) {
        VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, this.POSITION_TEX_NORMALF());
        tes.func_181662_b(x1, y1, z1).func_187315_a(u, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y2, z1).func_187315_a(u, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y2, z1).func_187315_a(u1, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y1, z1).func_187315_a(u1, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        tes.func_181668_a(7, this.POSITION_TEX_NORMALF());
        tes.func_181662_b(x1, y1, z2).func_187315_a(u, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y1, z2).func_187315_a(u, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y2, z2).func_187315_a(u1, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y2, z2).func_187315_a(u1, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        tes.func_181668_a(7, this.POSITION_TEX_NORMALF());
        tes.func_181662_b(x1, y1, z1).func_187315_a(u, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y1, z2).func_187315_a(u, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y2, z2).func_187315_a(u1, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y2, z1).func_187315_a(u1, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        tes.func_181668_a(7, this.POSITION_TEX_NORMALF());
        tes.func_181662_b(x2, y1, z1).func_187315_a(u, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y2, z1).func_187315_a(u, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y2, z2).func_187315_a(u1, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y1, z2).func_187315_a(u1, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        tes.func_181668_a(7, this.POSITION_TEX_NORMALF());
        tes.func_181662_b(x1, y1, z1).func_187315_a(u, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y1, z1).func_187315_a(u, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y1, z2).func_187315_a(u1, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y1, z2).func_187315_a(u1, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        tes.func_181668_a(7, this.POSITION_TEX_NORMALF());
        tes.func_181662_b(x1, y2, z1).func_187315_a(u, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x1, y2, z2).func_187315_a(u, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y2, z2).func_187315_a(u1, v1).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        tes.func_181662_b(x2, y2, z1).func_187315_a(u1, v).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void setupBillboard(Entity entity) {
        GL11.glRotatef((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public void renderSphere(float radius, int stacks, int slices, TextureAtlasSprite tex, DrawableShape.TEXTURE_MODE drawMode, Color color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.setColor(color);
        GL11.glEnable((int)3008);
        TexturedSphere sphere = new TexturedSphere();
        GL11.glShadeModel((int)7425);
        sphere.setDrawStyle(100012);
        sphere.setNormals(100000);
        sphere.setTextureFlag(true);
        sphere.setTextureMode(drawMode);
        sphere.setOrientation(100020);
        GL11.glTexCoord4f((float)tex.func_94209_e(), (float)tex.func_94212_f(), (float)tex.func_94206_g(), (float)tex.func_94210_h());
        sphere.draw(radius, slices, stacks, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
        GL11.glPopMatrix();
    }

    public void renderCylinder(float radius, int stacks, int slices, TextureAtlasSprite tex, DrawableShape.TEXTURE_MODE drawMode, Color color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.setColor(color);
        GL11.glEnable((int)3008);
        TexturedCylinder cylinder = new TexturedCylinder();
        GL11.glShadeModel((int)7425);
        cylinder.setDrawStyle(100012);
        cylinder.setNormals(100000);
        cylinder.setTextureFlag(true);
        cylinder.setTextureMode(drawMode);
        cylinder.setOrientation(100020);
        GL11.glTexCoord4f((float)tex.func_94209_e(), (float)tex.func_94212_f(), (float)tex.func_94206_g(), (float)tex.func_94210_h());
        cylinder.draw(radius, slices, stacks, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
        GL11.glPopMatrix();
    }

    public FloatBuffer matrixBuffer() {
        return this.matrixBuffer;
    }

    public void loadMatrix(Matrix4f transform) {
        transform.store(this.matrixBuffer());
        this.matrixBuffer().flip();
        GL11.glMultMatrix((FloatBuffer)this.matrixBuffer());
    }

    public Matrix4f createEntityRotateMatrix(Entity entity) {
        double yaw = Math.toRadians(entity.field_70177_z - (float)180);
        double pitch = Math.toRadians(entity.field_70125_A);
        Matrix4f initial = new Matrix4f();
        initial.rotate((float)pitch, new Vector3f(1.0f, 0.0f, 0.0f));
        initial.rotate((float)yaw, new Vector3f(0.0f, 1.0f, 0.0f));
        return initial;
    }

    private RenderUtils$() {
        MODULE$ = this;
        this.GUI_COMPONENTS = new ResourceLocation("bookshelfapi", "textures/gui/guiComponents.png");
        this.MC_BLOCKS = TextureMap.field_110575_b;
        this.MC_ITEMS = new ResourceLocation("textures/atlas/items.png");
        this.POSITION_TEX_NORMALF = new VertexFormat();
        this.NORMAL_3F = new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.NORMAL, 3);
        this.POSITION_TEX_NORMALF().func_181721_a(DefaultVertexFormats.field_181713_m);
        this.POSITION_TEX_NORMALF().func_181721_a(DefaultVertexFormats.field_181715_o);
        this.POSITION_TEX_NORMALF().func_181721_a(this.NORMAL_3F());
        this.matrixBuffer = BufferUtils.createFloatBuffer((int)16);
    }
}

