/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.teambr.bookshelf.helper.LogHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class JsonUtils {
    public static boolean writeToJson(Object toWrite, String path) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(toWrite);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path));
            writer.write(json);
            writer.close();
            return true;
        }
        catch (IOException e) {
            LogHelper.severe("Failed to write to: " + path);
            return false;
        }
    }

    public static <C> C readFromJson(TypeToken type, String path) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            Gson gson = new Gson();
            return (C)gson.fromJson((Reader)reader, type.getType());
        }
        catch (FileNotFoundException e) {
            LogHelper.severe("Could not find file: " + path);
            return null;
        }
    }
}

