/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.notification;

import com.teambr.bookshelf.Bookshelf;
import com.teambr.bookshelf.notification.Notification;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiNotification
extends Gui {
    private static final ResourceLocation backGround = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private Minecraft minecraft;
    private int width;
    private int height;
    private double duration;
    private String title;
    private String description;
    private Notification notification;
    private long timeOpen;
    private RenderItem itemRenderer;
    private boolean hide;
    private List<Notification> notifications = new ArrayList<Notification>();

    public GuiNotification(Minecraft mc) {
        this.minecraft = mc;
        this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
    }

    public void queueNotification(Notification notification1) {
        if (this.notifications.isEmpty()) {
            this.title = notification1.getTitle();
            this.description = notification1.getDescription();
            this.timeOpen = Minecraft.func_71386_F();
            this.duration = notification1.getDuration();
            this.notification = notification1;
        }
        this.notifications.add(notification1);
    }

    public void moveToNextNotification() {
        if (!this.notifications.isEmpty()) {
            this.notifications.remove(0);
            this.setDead();
            if (!this.notifications.isEmpty()) {
                this.title = this.notifications.get(0).getTitle();
                this.description = this.notifications.get(0).getDescription();
                this.timeOpen = Minecraft.func_71386_F();
                this.duration = this.notifications.get(0).getDuration();
                this.notification = this.notifications.get(0);
                this.hide = false;
            }
        }
    }

    private void updateScale() {
        GL11.glViewport((int)0, (int)0, (int)this.minecraft.field_71443_c, (int)this.minecraft.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.width = this.minecraft.field_71443_c;
        this.height = this.minecraft.field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft);
        this.width = scaledresolution.func_78326_a();
        this.height = scaledresolution.func_78328_b();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void update() {
        if (this.notification != null && this.timeOpen != 0L && Minecraft.func_71410_x().field_71439_g != null) {
            double d0 = (double)(Minecraft.func_71386_F() - this.timeOpen) / this.duration;
            if (!this.hide) {
                if (d0 < 0.0 || d0 > 1.0) {
                    this.timeOpen = 0L;
                    this.moveToNextNotification();
                    return;
                }
            } else if (d0 > 0.5) {
                d0 = 0.5;
            }
            this.updateScale();
            double d1 = d0 * 2.0;
            if (d1 > 1.0) {
                d1 = 2.0 - d1;
            }
            d1 *= 4.0;
            if ((d1 = 1.0 - d1) < 0.0) {
                d1 = 0.0;
            }
            d1 *= d1;
            d1 *= d1;
            int i = this.width / 2 - 80;
            switch (Bookshelf.notificationXPos()) {
                case 0: {
                    i = 0;
                    break;
                }
                case 2: {
                    i = this.width - 160;
                }
            }
            int j = 0 - (int)(d1 * 36.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            this.minecraft.func_110434_K().func_110577_a(backGround);
            GL11.glDisable((int)2896);
            this.func_73729_b(i, j, 96, 202, 160, 32);
            if (this.hide) {
                this.minecraft.field_71466_p.func_78279_b(this.description, i + 30, j + 7, 120, -1);
            } else {
                this.minecraft.field_71466_p.func_78276_b(this.title, i + 30, j + 7, -256);
                this.minecraft.field_71466_p.func_78276_b(this.description, i + 30, j + 18, -1);
            }
            RenderHelper.func_74520_c();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2903);
            GL11.glEnable((int)2896);
            this.itemRenderer.func_180450_b(this.notification.getIcon(), i + 8, j + 8);
            this.itemRenderer.func_180453_a(Minecraft.func_71410_x().field_71466_p, this.notification.getIcon(), i + 8, j + 8, null);
            GL11.glDisable((int)2896);
        }
    }

    public void setDead() {
        this.notification = null;
        this.timeOpen = 0L;
    }
}

