/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.common.tiles.traits;

import com.teambr.bookshelf.common.container.InventoryCallback;
import com.teambr.bookshelf.common.tiles.traits.Inventory;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public abstract class Inventory$class {
    public static Inventory addCallback(Inventory $this, InventoryCallback iInventory) {
        $this.callBacks().$plus$eq((Object)iInventory);
        return $this;
    }

    public static void onInventoryChanged(Inventory $this, int slot) {
        $this.callBacks().foreach((Function1)new Serializable($this, slot){
            private final /* synthetic */ Inventory $outer;
            private final int slot$1;

            public final void apply(InventoryCallback callBack) {
                callBack.onInventoryChanged((IItemHandler)this.$outer, this.slot$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.slot$1 = slot$1;
            }
        });
    }

    public static ItemStack addInventorySlot(Inventory $this, ItemStack stack) {
        return $this.inventoryContents().push(stack);
    }

    public static void addInventorySlots(Inventory $this, int count) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable($this){
            private final /* synthetic */ Inventory $outer;

            public final ItemStack apply(int i) {
                return this.$outer.addInventorySlot(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static ItemStack removeInventorySlot(Inventory $this) {
        return $this.inventoryContents().pop();
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack[] removeInventorySlots(Inventory $this, int count) {
        void var2_2;
        ItemStack[] poppedStack = new ItemStack[count];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable($this, poppedStack){
            private final /* synthetic */ Inventory $outer;
            private final ItemStack[] poppedStack$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.poppedStack$1[i] = this.$outer.removeInventorySlot();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.poppedStack$1 = poppedStack$1;
            }
        });
        return var2_2;
    }

    public static void copyFrom(Inventory $this, IItemHandler inventory) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), inventory.getSlots()).foreach$mVc$sp((Function1)new Serializable($this, inventory){
            private final /* synthetic */ Inventory $outer;
            private final IItemHandler inventory$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if (i < this.$outer.getSizeInventory()) {
                    ItemStack stack = this.inventory$1.getStackInSlot(i);
                    if (stack == null) {
                        this.$outer.setInventorySlotContents(i, null);
                    } else {
                        this.$outer.setInventorySlotContents(i, stack.func_77946_l());
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inventory$1 = inventory$1;
            }
        });
    }

    public static NBTTagCompound writeToNBT(Inventory $this, NBTTagCompound tag) {
        return $this.writeToNBT(tag, "");
    }

    public static NBTTagCompound writeToNBT(Inventory $this, NBTTagCompound tag, String inventoryName) {
        tag.func_74768_a(new StringBuilder().append((Object)"Size:").append((Object)inventoryName).toString(), $this.getSizeInventory());
        NBTTagList nbttaglist = new NBTTagList();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.inventoryContents().size()).foreach$mVc$sp((Function1)new Serializable($this, nbttaglist, inventoryName){
            private final /* synthetic */ Inventory $outer;
            private final NBTTagList nbttaglist$1;
            private final String inventoryName$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if (this.$outer.inventoryContents().get(i) != null) {
                    NBTTagCompound stackTag = new NBTTagCompound();
                    stackTag.func_74774_a(new StringBuilder().append((Object)"Slot:").append((Object)this.inventoryName$1).toString(), (byte)i);
                    ((ItemStack)this.$outer.inventoryContents().get(i)).func_77955_b(stackTag);
                    this.nbttaglist$1.func_74742_a((NBTBase)stackTag);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nbttaglist$1 = nbttaglist$1;
                this.inventoryName$1 = inventoryName$1;
            }
        });
        tag.func_74782_a(new StringBuilder().append((Object)"Items:").append((Object)inventoryName).toString(), (NBTBase)nbttaglist);
        return tag;
    }

    public static void readFromNBT(Inventory $this, NBTTagCompound tag) {
        $this.readFromNBT(tag, "");
    }

    public static void readFromNBT(Inventory $this, NBTTagCompound tag, String inventoryName) {
        NBTTagList nbttaglist = tag.func_150295_c(new StringBuilder().append((Object)"Items:").append((Object)inventoryName).toString(), 10);
        $this.inventoryContents_$eq(new Stack<ItemStack>());
        if (tag.func_74764_b(new StringBuilder().append((Object)"Size:").append((Object)inventoryName).toString())) {
            $this.inventoryContents().setSize(tag.func_74762_e(new StringBuilder().append((Object)"Size:").append((Object)inventoryName).toString()));
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nbttaglist.func_74745_c()).foreach((Function1)new Serializable($this, nbttaglist, inventoryName){
            private final /* synthetic */ Inventory $outer;
            private final NBTTagList nbttaglist$2;
            private final String inventoryName$2;

            public final Object apply(int i) {
                NBTTagCompound stacktag = this.nbttaglist$2.func_150305_b(i);
                byte j = stacktag.func_74771_c(new StringBuilder().append((Object)"Slot:").append((Object)this.inventoryName$2).toString());
                return j >= 0 && j < this.$outer.inventoryContents().size() ? this.$outer.inventoryContents().set(j, ItemStack.func_77949_a((NBTTagCompound)stacktag)) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nbttaglist$2 = nbttaglist$2;
                this.inventoryName$2 = inventoryName$2;
            }
        });
    }

    public static boolean hasCapability(Inventory $this, Capability capability, EnumFacing facing) {
        Capability capability2 = capability;
        Capability capability3 = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        return !(capability2 != null ? !capability2.equals(capability3) : capability3 != null);
    }

    public static Object getCapability(Inventory $this, Capability capability, EnumFacing facing) {
        Capability capability2 = capability;
        Capability capability3 = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        return !(capability2 != null ? !capability2.equals(capability3) : capability3 != null) ? $this : $this.com$teambr$bookshelf$common$tiles$traits$Inventory$$super$getCapability(capability, facing);
    }

    public static int getSlots(Inventory $this) {
        return $this.getSizeInventory();
    }

    public static ItemStack insertItem(Inventory $this, int slot, ItemStack originalStack, boolean simulate) {
        block14: {
            block17: {
                ItemStack itemStack;
                block16: {
                    int minimum;
                    ItemStack stackInSlot;
                    block15: {
                        if (originalStack == null) {
                            return null;
                        }
                        if (!$this.isItemValidForSlot(slot, originalStack)) break block14;
                        stackInSlot = $this.getStackInSlot(slot);
                        minimum = 0;
                        if (stackInSlot != null) break block15;
                        minimum = Math.min(originalStack.func_77976_d(), $this.getInventoryStackLimit());
                        if (minimum < originalStack.field_77994_a) {
                            if (simulate) {
                                originalStack.field_77994_a -= minimum;
                                itemStack = originalStack;
                            } else {
                                $this.setInventorySlotContents(slot, originalStack.func_77979_a(minimum));
                                $this.onInventoryChanged(0);
                                itemStack = originalStack;
                            }
                        } else {
                            if (!simulate) {
                                $this.setInventorySlotContents(slot, originalStack);
                                $this.onInventoryChanged(0);
                            }
                            itemStack = null;
                        }
                        break block16;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)originalStack, (ItemStack)stackInSlot)) break block17;
                    minimum = Math.min(originalStack.func_77976_d(), $this.getInventoryStackLimit()) - stackInSlot.field_77994_a;
                    if (originalStack.field_77994_a <= minimum) {
                        if (!simulate) {
                            ItemStack stackCopy = originalStack.func_77946_l();
                            stackCopy.field_77994_a += stackInSlot.field_77994_a;
                            $this.setInventorySlotContents(slot, stackCopy);
                            $this.onInventoryChanged(0);
                        }
                        itemStack = null;
                    } else if (simulate) {
                        originalStack.field_77994_a -= minimum;
                        itemStack = originalStack;
                    } else {
                        ItemStack stackCopy = originalStack.func_77979_a(minimum);
                        stackCopy.field_77994_a += stackInSlot.field_77994_a;
                        $this.setInventorySlotContents(slot, stackCopy);
                        $this.onInventoryChanged(0);
                        itemStack = originalStack;
                    }
                }
                return itemStack;
            }
            return originalStack;
        }
        return originalStack;
    }

    public static ItemStack extractItem(Inventory $this, int extractSlot, int amount, boolean simulate) {
        ItemStack itemStack;
        if (amount == 0) {
            return null;
        }
        ItemStack stackInSlot = $this.getStackInSlot(extractSlot);
        if (stackInSlot == null) {
            return null;
        }
        if (simulate) {
            if (stackInSlot.field_77994_a < amount) {
                itemStack = stackInSlot.func_77946_l();
            } else {
                ItemStack copy = stackInSlot.func_77946_l();
                copy.field_77994_a = amount;
                itemStack = copy;
            }
        } else {
            int m = Math.min(stackInSlot.field_77994_a, amount);
            ItemStack decrStackSizeVal = $this.decrStackSize(extractSlot, m);
            $this.onInventoryChanged(0);
            itemStack = decrStackSizeVal;
        }
        return itemStack;
    }

    public static ItemStack getStackInSlot(Inventory $this, int index) {
        return index < $this.inventoryContents().size() ? (ItemStack)$this.inventoryContents().get(index) : null;
    }

    public static void setStackInSlot(Inventory $this, int slot, ItemStack stack) {
        $this.setInventorySlotContents(slot, stack);
    }

    public static ItemStack decrStackSize(Inventory $this, int slot, int amount) {
        if ($this.inventoryContents().get(slot) == null) {
            return null;
        }
        ItemStack stack = null;
        if (((ItemStack)$this.inventoryContents().get((int)slot)).field_77994_a <= amount) {
            stack = (ItemStack)$this.inventoryContents().get(slot);
            $this.inventoryContents().set(slot, null);
            $this.onInventoryChanged(slot);
            return stack;
        }
        stack = ((ItemStack)$this.inventoryContents().get(slot)).func_77979_a(amount);
        Object object = ((ItemStack)$this.inventoryContents().get((int)slot)).field_77994_a <= 0 ? $this.inventoryContents().set(slot, null) : BoxedUnit.UNIT;
        $this.onInventoryChanged(slot);
        return stack;
    }

    public static int getInventoryStackLimit(Inventory $this) {
        return 64;
    }

    public static int getSizeInventory(Inventory $this) {
        return $this.inventoryContents().size();
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack removeStackFromSlot(Inventory $this, int index) {
        void var2_2;
        ItemStack stack = ((ItemStack)$this.inventoryContents().get(index)).func_77946_l();
        $this.inventoryContents().set(index, null);
        return var2_2;
    }

    public static ItemStack getStackInSlotOnClosing(Inventory $this, int index) {
        if (index >= $this.inventoryContents().size()) {
            return null;
        }
        if ($this.inventoryContents().get(index) == null) {
            return null;
        }
        ItemStack stack = (ItemStack)$this.inventoryContents().get(index);
        $this.inventoryContents().set(index, null);
        return stack;
    }

    public static boolean isItemValidForSlot(Inventory $this, int index, ItemStack stack) {
        return true;
    }

    public static boolean isUseableByPlayer(Inventory $this, EntityPlayer player) {
        return !((TileEntity)$this).func_145837_r();
    }

    public static void setInventorySlotContents(Inventory $this, int index, ItemStack stack) {
        $this.inventoryContents().set(index, stack);
        if (stack != null && stack.field_77994_a > $this.getInventoryStackLimit()) {
            stack.field_77994_a = $this.getInventoryStackLimit();
        }
        $this.onInventoryChanged(index);
    }

    public static void thisIsDirty(Inventory $this) {
        $this.onInventoryChanged(0);
    }

    public static void clear(Inventory $this) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.inventoryContents().size()).foreach((Function1)new Serializable($this){
            private final /* synthetic */ Inventory $outer;

            public final ItemStack apply(int i) {
                return this.$outer.inventoryContents().set(i, null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void openInventory(Inventory $this, EntityPlayer player) {
    }

    public static void closeInventory(Inventory $this, EntityPlayer player) {
    }

    public static void $init$(Inventory $this) {
        $this.com$teambr$bookshelf$common$tiles$traits$Inventory$_setter_$callBacks_$eq(new ArrayBuffer());
        $this.inventoryContents_$eq(new Stack<ItemStack>());
        $this.inventoryContents().setSize($this.initialSize());
    }
}

