/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.common.tiles.traits;

import cofh.api.energy.EnergyStorage;
import com.teambr.bookshelf.common.tiles.traits.EnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import scala.runtime.BoxedUnit;

public abstract class EnergyHandler$class {
    public static void update(EnergyHandler $this) {
        $this.com$teambr$bookshelf$common$tiles$traits$EnergyHandler$$super$update();
        $this.ticker_$eq($this.ticker() - 1);
        if ($this.ticker() <= 0) {
            $this.ticker_$eq($this.checkDelay());
            $this.energyIn_$eq(0);
            $this.energyOut_$eq(0);
        }
    }

    public static NBTTagCompound writeToNBT(EnergyHandler $this, NBTTagCompound tag) {
        tag.func_74768_a("CurrentEnergy", $this.energyStorage().getEnergyStored());
        tag.func_74768_a("EnergyCapacity", $this.energyStorage().getMaxEnergyStored());
        tag.func_74768_a("MaxExtract", $this.energyStorage().getMaxExtract());
        tag.func_74768_a("MaxReceive", $this.energyStorage().getMaxReceive());
        tag.func_74768_a("EnergyIn", $this.energyIn());
        tag.func_74768_a("EnergyOut", $this.energyOut());
        return tag;
    }

    public static void readFromNBT(EnergyHandler $this, NBTTagCompound tag) {
        $this.energyStorage().setCapacity(tag.func_74762_e("EnergyCapacity"));
        Object object = $this.energyStorage().getMaxEnergyStored() == 0 ? $this.energyStorage().setCapacity($this.defaultEnergyStorageSize()) : BoxedUnit.UNIT;
        $this.energyStorage().setEnergyStored(tag.func_74762_e("CurrentEnergy"));
        $this.energyStorage().setMaxExtract(tag.func_74762_e("MaxExtract"));
        $this.energyStorage().setMaxReceive(tag.func_74762_e("MaxReceive"));
        $this.energyIn_$eq(tag.func_74762_e("EnergyIn"));
        $this.energyOut_$eq(tag.func_74762_e("EnergyOut"));
        Object object2 = $this.energyStorage().getMaxExtract() == 0 ? $this.energyStorage().setMaxExtract($this.defaultEnergyStorageSize()) : BoxedUnit.UNIT;
        if ($this.energyStorage().getMaxReceive() == 0) {
            $this.energyStorage().setMaxReceive($this.defaultEnergyStorageSize());
        }
    }

    public static int checkDelay(EnergyHandler $this) {
        return 40;
    }

    public static int getRFInPerTick(EnergyHandler $this) {
        return $this.energyIn();
    }

    public static int getRFOutPerTick(EnergyHandler $this) {
        return $this.energyOut();
    }

    public static void setMaxExtract(EnergyHandler $this, int maxExtract) {
        $this.energyStorage().setMaxExtract(maxExtract);
    }

    public static void setMaxReceive(EnergyHandler $this, int maxReceive) {
        $this.energyStorage().setMaxReceive(maxReceive);
    }

    public static void setMaxEnergyStored(EnergyHandler $this, int maxEnergyStored) {
        $this.energyStorage().setCapacity(maxEnergyStored);
    }

    public static int getEnergyStored(EnergyHandler $this, EnumFacing from) {
        return $this.energyStorage().getEnergyStored();
    }

    public static int getMaxEnergyStored(EnergyHandler $this, EnumFacing from) {
        return $this.energyStorage().getMaxEnergyStored();
    }

    public static boolean canConnectEnergy(EnergyHandler $this, EnumFacing from) {
        return true;
    }

    public static int receiveEnergy(EnergyHandler $this, EnumFacing from, int maxReceive, boolean simulate) {
        int n;
        if ($this.isReceiver()) {
            if ($this.energyStorage() == null) {
                n = 0;
            } else {
                int actual = $this.energyStorage().receiveEnergy(maxReceive, simulate);
                if (!simulate) {
                    $this.energyIn_$eq(actual);
                    $this.ticker_$eq(20);
                }
                if (((TileEntity)$this).func_145831_w() != null) {
                    ((TileEntity)$this).func_145831_w().func_184138_a(((TileEntity)$this).func_174877_v(), ((TileEntity)$this).func_145831_w().func_180495_p(((TileEntity)$this).func_174877_v()), ((TileEntity)$this).func_145831_w().func_180495_p(((TileEntity)$this).func_174877_v()), 3);
                }
                n = actual;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public static int extractEnergy(EnergyHandler $this, EnumFacing from, int maxExtract, boolean simulate) {
        int n;
        if ($this.isProvider()) {
            if ($this.energyStorage() == null) {
                n = 0;
            } else {
                int actual = $this.energyStorage().extractEnergy(maxExtract, simulate);
                if (!simulate) {
                    $this.energyOut_$eq(-actual);
                    $this.ticker_$eq(20);
                }
                if (((TileEntity)$this).func_145831_w() != null) {
                    ((TileEntity)$this).func_145831_w().func_184138_a(((TileEntity)$this).func_174877_v(), ((TileEntity)$this).func_145831_w().func_180495_p(((TileEntity)$this).func_174877_v()), ((TileEntity)$this).func_145831_w().func_180495_p(((TileEntity)$this).func_174877_v()), 3);
                }
                n = actual;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public static void $init$(EnergyHandler $this) {
        $this.com$teambr$bookshelf$common$tiles$traits$EnergyHandler$_setter_$energyStorage_$eq(new EnergyStorage($this.defaultEnergyStorageSize()));
        $this.energyIn_$eq(0);
        $this.energyOut_$eq(0);
        $this.ticker_$eq(0);
    }
}

