/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.common.items.traits;

import com.teambr.bookshelf.common.items.traits.ItemBattery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class ItemBattery$class {
    public static void onCreated(ItemBattery $this, ItemStack stack, World worldIn, EntityPlayer playerIn) {
        $this.setDefaultTags(stack);
        $this.updateDamage(stack);
    }

    public static void onUpdate(ItemBattery $this, ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            $this.setDefaultTags(stack);
        }
    }

    public static int receiveEnergy(ItemBattery $this, ItemStack stack, int maxReceive, boolean simulate) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int energy = stack.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(stack.func_77978_p().func_74762_e("EnergyCapacity") - energy, Math.min(stack.func_77978_p().func_74762_e("MaxReceive"), maxReceive));
        if (!simulate) {
            stack.func_77978_p().func_74768_a("Energy", energy += energyReceived);
            $this.updateDamage(stack);
        }
        return energyReceived;
    }

    public static int extractEnergy(ItemBattery $this, ItemStack stack, int maxExtract, boolean simulate) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Energy")) {
            int energy = stack.func_77978_p().func_74762_e("Energy");
            int energyExtracted = Math.min(energy, Math.min(stack.func_77978_p().func_74762_e("MaxExtract"), maxExtract));
            if (!simulate) {
                stack.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
                $this.updateDamage(stack);
            }
            return energyExtracted;
        }
        return 0;
    }

    public static int getEnergyStored(ItemBattery $this, ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Energy")) {
            return stack.func_77978_p().func_74762_e("Energy");
        }
        return 0;
    }

    public static int getMaxEnergyStored(ItemBattery $this, ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("EnergyCapacity")) {
            return stack.func_77978_p().func_74762_e("EnergyCapacity");
        }
        return 0;
    }

    public static void updateDamage(ItemBattery $this, ItemStack stack) {
        float r = (float)$this.getEnergyStored(stack) / (float)$this.getMaxEnergyStored(stack);
        int res = 16 - Math.round(r * (float)16);
        if (r < 1.0f && res == 0) {
            res = 1;
        }
        stack.func_77964_b(res);
    }

    public static void $init$(ItemBattery $this) {
        ((Item)$this).func_77656_e(16);
        ((Item)$this).setNoRepair();
    }
}

