/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.collections;

import com.teambr.bookshelf.common.tiles.traits.InventorySided;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SidedInventoryWrapper
implements IItemHandlerModifiable {
    protected final InventorySided inv;
    protected final EnumFacing side;

    public SidedInventoryWrapper(InventorySided inv, EnumFacing side) {
        this.inv = inv;
        this.side = side;
    }

    public static int getSlot(InventorySided inv, int slot, EnumFacing side) {
        int[] slots = inv.getSlotsForFace(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedInventoryWrapper that = (SidedInventoryWrapper)o;
        return this.inv.equals(that.inv) && this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + this.side.hashCode();
        return result;
    }

    public int getSlots() {
        return this.inv.getSlotsForFace(this.side).length;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = SidedInventoryWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? null : this.inv.getStackInSlot(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack == null) {
            return null;
        }
        int slot1 = SidedInventoryWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        if (!this.inv.isItemValidForSlot(slot1, stack) || !this.inv.canInsertItem(slot1, stack, this.side)) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot1);
        if (stackInSlot != null) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.inv.getInventoryStackLimit()) - stackInSlot.field_77994_a;
            if (stack.field_77994_a <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a += stackInSlot.field_77994_a;
                    this.inv.setInventorySlotContents(slot1, copy);
                }
                return null;
            }
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.field_77994_a += stackInSlot.field_77994_a;
                this.inv.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.field_77994_a -= m;
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.inv.getInventoryStackLimit());
        if (m < stack.field_77994_a) {
            if (!simulate) {
                this.inv.setInventorySlotContents(slot1, stack.func_77979_a(m));
                return stack;
            }
            stack.field_77994_a -= m;
            return stack;
        }
        if (!simulate) {
            this.inv.setInventorySlotContents(slot1, stack);
        }
        return null;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        int slot1 = SidedInventoryWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return null;
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot1);
        if (stackInSlot == null) {
            return null;
        }
        if (!this.inv.canExtractItem(slot1, stackInSlot, this.side)) {
            return null;
        }
        if (simulate) {
            if (stackInSlot.field_77994_a < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.field_77994_a = amount;
            return copy;
        }
        int m = Math.min(stackInSlot.field_77994_a, amount);
        return this.inv.decrStackSize(slot1, m);
    }
}

