/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.client.shapes;

import com.teambr.bookshelf.client.shapes.DrawableShape;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class TexturedSphere
extends DrawableShape {
    protected float cos(float r) {
        return MathHelper.func_76134_b((float)r);
    }

    protected float sin(float r) {
        return MathHelper.func_76126_a((float)r);
    }

    public void draw(float radius, int slices, int stacks, float minU, float maxU, float minV, float maxV) {
        float nsign = this.orientation == 100021 ? -1.0f : 1.0f;
        float PI = (float)Math.PI;
        float drho = PI / (float)stacks;
        float dtheta = 2.0f * PI / (float)slices;
        float stackUSize = (maxU - minU) / (float)(slices + 1);
        float stackVSize = (maxV - minV) / (float)(stacks + 1);
        for (int i = 0; i < stacks; ++i) {
            float rho = (float)i * drho;
            GL11.glBegin((int)8);
            for (int j = 0; j <= slices; ++j) {
                float yTexCoord;
                float xTexCoord;
                float theta = j == slices ? 0.0f : (float)j * dtheta;
                float x = -this.sin(theta) * this.sin(rho);
                float y = this.cos(theta) * this.sin(rho);
                float z = nsign * this.cos(rho);
                switch (this.textureMode) {
                    case PANEL: {
                        xTexCoord = j % 2 == 0 ? minU : maxU;
                        yTexCoord = minV;
                        break;
                    }
                    default: {
                        xTexCoord = j % 2 == 0 ? minU + (float)j * stackUSize + stackUSize : minU + (float)j * stackUSize + stackUSize;
                        yTexCoord = minV + (float)i * stackVSize;
                    }
                }
                GL11.glTexCoord2f((float)xTexCoord, (float)yTexCoord);
                GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
                x = -this.sin(theta) * this.sin(rho + drho);
                y = this.cos(theta) * this.sin(rho + drho);
                z = nsign * this.cos(rho + drho);
                switch (this.textureMode) {
                    case PANEL: {
                        xTexCoord = j % 2 == 0 ? minU : maxU;
                        yTexCoord = maxV;
                        break;
                    }
                    default: {
                        xTexCoord = j % 2 == 0 ? minU + (float)j * stackUSize + stackUSize : minU + (float)j * stackUSize + stackUSize;
                        yTexCoord = minV + (float)i * stackVSize + stackVSize;
                    }
                }
                GL11.glTexCoord2f((float)xTexCoord, (float)yTexCoord);
                GL11.glNormal3f((float)(x * nsign), (float)(y * nsign), (float)(z * nsign));
                GL11.glVertex3f((float)(x * radius), (float)(y * radius), (float)(z * radius));
            }
            GL11.glEnd();
        }
    }
}

