/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.client.models;

import com.google.common.collect.ImmutableList;
import com.teambr.bookshelf.client.ModelHelper;
import com.teambr.bookshelf.common.items.traits.ItemModelProvider;
import com.teambr.bookshelf.lib.Reference;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedDynItem
implements IBakedModel,
IPerspectiveAwareModel {
    public static final ModelResourceLocation MODEL_RESOURCE_LOCATION = new ModelResourceLocation(new ResourceLocation(Reference.MODID(), "dynItem"), "inventory");
    protected static final THashMap<List<String>, BakedDynItem> modelCache = new THashMap();
    protected List<String> textureLocations;
    protected List<BakedQuad> quads = null;
    protected boolean isTool = false;

    public BakedDynItem() {
    }

    public BakedDynItem(List<String> textures) {
        this(textures, false);
    }

    public BakedDynItem(List<String> textures, boolean tool) {
        this.textureLocations = textures;
        this.isTool = tool;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (this.quads == null || this.textureLocations != null && this.quads.size() == 0) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String loc : this.textureLocations) {
                builder.add((Object)new ResourceLocation(loc));
            }
            this.quads = new ItemLayerModel(builder.build()).bake(ModelHelper.DEFAULT_ITEM_STATE(), DefaultVertexFormats.field_176599_b, ModelHelper.textureGetter()).func_188616_a(state, side, rand);
        }
        return this.quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(this.textureLocations.get(0));
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return BakedDynItemOverride.INSTANCE;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)(this.isTool ? ModelHelper.DEFAULT_TOOL_STATE() : ModelHelper.DEFAULT_ITEM_STATE()), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public static final class BakedDynItemOverride
    extends ItemOverrideList {
        public static final BakedDynItemOverride INSTANCE = new BakedDynItemOverride();

        private BakedDynItemOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (stack.func_77973_b() instanceof ItemModelProvider) {
                List<String> textureList = ((ItemModelProvider)stack.func_77973_b()).getTextures(stack);
                if (modelCache.containsKey(textureList)) {
                    return (IBakedModel)modelCache.get(textureList);
                }
                modelCache.put(textureList, (Object)new BakedDynItem(textureList, ((ItemModelProvider)stack.func_77973_b()).isTool()));
                return (IBakedModel)modelCache.getOrDefault(textureList, (Object)new BakedDynItem(textureList, ((ItemModelProvider)stack.func_77973_b()).isTool()));
            }
            return originalModel;
        }
    }
}

