/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.teambr.bookshelf.client.TextureManager;
import com.teambr.bookshelf.common.blocks.BlockConnectedTextures;
import com.teambr.bookshelf.common.blocks.ConnectedTexturesState;
import com.teambr.bookshelf.lib.Reference;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class BakedConnectedTextures
implements IBakedModel,
IPerspectiveAwareModel {
    public static final ModelResourceLocation MODEL_RESOURCE_LOCATION_NORMAL = new ModelResourceLocation(new ResourceLocation(Reference.MODID(), "connectedTextures"), "normal");
    protected static final FaceBakery faceBakery = new FaceBakery();
    public static final THashMap<TextureAtlasSprite, BakedConnectedTextures> modelCache = new THashMap();
    private static Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)BakedConnectedTextures.get(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)BakedConnectedTextures.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedConnectedTextures.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)BakedConnectedTextures.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedConnectedTextures.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedConnectedTextures.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedConnectedTextures.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)BakedConnectedTextures.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).build();
    protected BlockConnectedTextures block;
    protected IBlockAccess world;
    protected BlockPos pos;
    public boolean isItem = false;

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new javax.vecmath.Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((javax.vecmath.Vector3f)new javax.vecmath.Vector3f(ax, ay, az)), new javax.vecmath.Vector3f(s, s, s), null);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)transforms.get(cameraTransformType).getMatrix());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (!this.isItem && side != null && state instanceof ConnectedTexturesState) {
            ConnectedTexturesState newState = (ConnectedTexturesState)state;
            this.world = newState.world;
            this.pos = newState.pos;
            this.block = newState.block;
            if (this.world.func_180495_p(this.pos.func_177972_a(side)).func_177230_c() == this.block) {
                return new ArrayList<BakedQuad>();
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ModelRotation rot = this.lookUpRotationForFace(side);
            boolean[] connections = this.block.getConnectionArrayForFace(this.world, this.pos, side);
            quads.add(faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(8.0f, 8.0f, 16.0f), new BlockPartFace(null, 0, "", new BlockFaceUV(new float[]{0.0f, 8.0f, 8.0f, 0.0f}, 0)), this.block.getConnectedTextures().getTextureForCorner(2, connections), EnumFacing.SOUTH, rot, null, false, true));
            quads.add(faceBakery.func_178414_a(new Vector3f(8.0f, 0.0f, 16.0f), new Vector3f(16.0f, 8.0f, 16.0f), new BlockPartFace(null, 0, "", new BlockFaceUV(new float[]{8.0f, 8.0f, 16.0f, 0.0f}, 0)), this.block.getConnectedTextures().getTextureForCorner(3, connections), EnumFacing.SOUTH, rot, null, false, true));
            quads.add(faceBakery.func_178414_a(new Vector3f(0.0f, 8.0f, 16.0f), new Vector3f(8.0f, 16.0f, 16.0f), new BlockPartFace(null, 0, "", new BlockFaceUV(new float[]{0.0f, 16.0f, 8.0f, 8.0f}, 0)), this.block.getConnectedTextures().getTextureForCorner(0, connections), EnumFacing.SOUTH, rot, null, false, true));
            quads.add(faceBakery.func_178414_a(new Vector3f(8.0f, 8.0f, 16.0f), new Vector3f(16.0f, 16.0f, 16.0f), new BlockPartFace(null, 0, "", new BlockFaceUV(new float[]{8.0f, 16.0f, 16.0f, 8.0f}, 0)), this.block.getConnectedTextures().getTextureForCorner(1, connections), EnumFacing.SOUTH, rot, null, false, true));
            return quads;
        }
        if (this.block != null && side != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            BlockPartFace face = new BlockPartFace(null, 0, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
            ModelRotation rot = this.lookUpRotationForFace(EnumFacing.SOUTH);
            for (EnumFacing facing : EnumFacing.values()) {
                quads.add(faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, TextureManager.getTexture(this.block.getConnectedTextures().corners()), facing, rot, null, true, true));
            }
            return quads;
        }
        return new ArrayList<BakedQuad>();
    }

    private ModelRotation lookUpRotationForFace(EnumFacing face) {
        switch (face) {
            case UP: {
                return ModelRotation.X90_Y0;
            }
            case DOWN: {
                return ModelRotation.X270_Y0;
            }
            case NORTH: {
                return ModelRotation.X0_Y180;
            }
            case EAST: {
                return ModelRotation.X0_Y270;
            }
            case SOUTH: {
                return ModelRotation.X0_Y0;
            }
            case WEST: {
                return ModelRotation.X0_Y90;
            }
        }
        return ModelRotation.X0_Y0;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.block == null ? Minecraft.func_71410_x().func_147117_R().func_174944_f() : TextureManager.getTexture(this.block.getConnectedTextures().corners());
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return BakedConnectedTexturesOverride.INSTANCE;
    }

    public static final class BakedConnectedTexturesOverride
    extends ItemOverrideList {
        public static final BakedConnectedTexturesOverride INSTANCE = new BakedConnectedTexturesOverride();

        private BakedConnectedTexturesOverride() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockConnectedTextures) {
                BlockConnectedTextures block = (BlockConnectedTextures)Block.func_149634_a((Item)stack.func_77973_b());
                if (modelCache.containsKey((Object)TextureManager.getTexture(block.getConnectedTextures().noConnections()))) {
                    return (IBakedModel)modelCache.get((Object)TextureManager.getTexture(block.getConnectedTextures().noConnections()));
                }
                BakedConnectedTextures model = new BakedConnectedTextures();
                model.isItem = true;
                model.block = block;
                modelCache.put((Object)TextureManager.getTexture(block.getConnectedTextures().noConnections()), (Object)model);
                return (IBakedModel)modelCache.getOrDefault((Object)block.getConnectedTextures().noConnections(), (Object)model);
            }
            return originalModel;
        }
    }
}

