/*
 * Decompiled with CFR 0.152.
 */
package com.teambr.bookshelf.achievement;

import com.teambr.bookshelf.achievement.AchievementRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;

public abstract class AchievementList {
    private String label;
    protected List<Achievement> achievements = new ArrayList<Achievement>();

    public AchievementList(String name) {
        this.label = name;
        AchievementRegistry.instance.putAchievementList(this);
        this.initAchievements();
        AchievementRegistry.instance.registerModAchievements(this.label, this.achievements.toArray(new Achievement[this.achievements.size()]));
    }

    public abstract void initAchievements();

    public void start() {
    }

    public String getName() {
        return this.label;
    }

    public List<Achievement> getAchievements() {
        return this.achievements;
    }

    public Achievement getAchievementByName(String id) {
        for (Achievement achievement : this.achievements) {
            if (!achievement.field_75975_e.equals(id)) continue;
            return achievement;
        }
        return null;
    }

    public void buildAchievement(String id, int x, int y, Item stack, Achievement parent) {
        this.achievements.add(new Achievement(id, id, x, y, stack, parent).func_75971_g());
    }

    public void buildAchievement(String id, int x, int y, Block stack, Achievement parent) {
        this.achievements.add(new Achievement(id, id, x, y, stack, parent).func_75971_g());
    }

    public void buildAchievement(String id, int x, int y, ItemStack stack, Achievement parent) {
        this.achievements.add(new Achievement(id, id, x, y, stack, parent).func_75971_g());
    }
}

