/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.simplequarry.utils;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemStackUtil {
    public static boolean tagsEqual(NBTTagCompound a, NBTTagCompound b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals((Object)b);
    }

    public static boolean itemsEqual(ItemStack a, ItemStack b) {
        if (("" + a).equals("" + b)) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77952_i() == b.func_77952_i() && ItemStackUtil.tagsEqual(a.func_77978_p(), b.func_77978_p());
    }

    public static boolean contains(ItemStack[] stacks, ItemStack stack) {
        stacks = Arrays.copyOf(stacks, stacks.length);
        stack = ItemStack.func_77944_b((ItemStack)stack);
        for (ItemStack s : stacks) {
            if (!ItemStackUtil.itemsEqual(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static void splitOrDropItemAround(ItemStack stack, World w, BlockPos from, ItemDropData data, EnumFacing ... blackist) {
        if (ItemStackUtil.shouldReturn(stack = ItemStackUtil.splitItemAround(stack, w, from, blackist))) {
            return;
        }
        EntityItem i = new EntityItem(w, (double)from.func_177958_n() + 0.5, (double)(from.func_177956_o() + 1), (double)from.func_177952_p() + 0.5, stack);
        i.func_70016_h(0.0, 0.0, 0.0);
        i.field_70173_aa = -data.despawnTime;
        if (data.pickupDelayMode == 0) {
            i.func_174871_r();
        } else if (data.pickupDelayMode == 2) {
            i.func_174868_q();
        }
        w.func_72838_d((Entity)i);
    }

    public static ItemStack splitItemAround(ItemStack stack, World w, BlockPos from, EnumFacing ... blackist) {
        stack = stack.func_77946_l();
        if (w.field_72995_K) {
            return stack;
        }
        List<EnumFacing> b = Arrays.asList(blackist);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IInventory i;
            if (b.contains(f)) continue;
            TileEntity entity = w.func_175625_s(from.func_177972_a(f));
            if (entity instanceof TileEntityChest) {
                i = (IInventory)entity;
                if (!ItemStackUtil.shouldReturn(stack = ItemStackUtil.insert(i, stack))) {
                    for (EnumFacing f2 : EnumFacing.field_82609_l) {
                        TileEntity entity2;
                        if (f2 == EnumFacing.UP || f2 == EnumFacing.DOWN || !((entity2 = w.func_175625_s(entity.func_174877_v().func_177972_a(f2))) instanceof TileEntityChest)) continue;
                        i = (IInventory)entity2;
                        stack = ItemStackUtil.insert(i, stack);
                    }
                }
            } else if (entity instanceof IInventory) {
                if (entity instanceof ISidedInventory) {
                    i = (ISidedInventory)entity;
                    stack = ItemStackUtil.insertSided((ISidedInventory)i, stack, f.func_176734_d());
                } else {
                    i = (IInventory)entity;
                    stack = ItemStackUtil.insert(i, stack);
                }
            }
            if (!ItemStackUtil.shouldReturn(stack)) continue;
            return null;
        }
        return stack;
    }

    public static ItemStack insert(IInventory to, ItemStack what) {
        if (to instanceof TileEntity && ((TileEntity)to).func_145831_w().field_72995_K) {
            return what;
        }
        what = what.func_77946_l();
        if (to instanceof ISidedInventory) {
            return ItemStackUtil.insertSided((ISidedInventory)to, what, EnumFacing.DOWN);
        }
        for (int i = 0; i < to.func_70302_i_(); ++i) {
            if (!to.func_94041_b(i, what)) continue;
            ItemStack in = to.func_70301_a(i);
            if (in == null) {
                to.func_70299_a(i, what);
                return null;
            }
            if (ItemStackUtil.itemsEqual(what, in) && in.field_77994_a < in.func_77976_d()) {
                int howM = what.field_77994_a;
                while (howM + in.field_77994_a > in.func_77976_d()) {
                    --howM;
                }
                what.field_77994_a -= howM;
                in.field_77994_a += howM;
            }
            if (!ItemStackUtil.shouldReturn(what)) continue;
            return null;
        }
        return what;
    }

    public static ItemStack insertSided(ISidedInventory to, ItemStack what, EnumFacing from) {
        for (int i = 0; i < to.func_70302_i_(); ++i) {
            if (!to.func_180462_a(i, what, from) && !to.func_94041_b(i, what)) continue;
            ItemStack in = to.func_70301_a(i);
            if (in == null) {
                to.func_70299_a(i, what);
                return null;
            }
            if (ItemStackUtil.itemsEqual(what, in) && in.field_77994_a < in.func_77976_d()) {
                int howM = what.field_77994_a;
                while (howM + in.field_77994_a > in.func_77976_d()) {
                    --howM;
                }
                what.field_77994_a -= howM;
                in.field_77994_a += howM;
            }
            if (!ItemStackUtil.shouldReturn(what)) continue;
            return null;
        }
        return what;
    }

    public static boolean shouldReturn(ItemStack stack) {
        return stack == null || stack.field_77994_a < 1;
    }

    public static final class ItemDropData {
        public static final ItemDropData QUARRY_DROP_DATA = new ItemDropData(2, 12000);
        public int pickupDelayMode = 1;
        public int despawnTime = 6000;

        public ItemDropData(int pickupDelayMode, int despawnTime) {
            this.pickupDelayMode = pickupDelayMode;
            this.despawnTime = despawnTime;
        }
    }
}

