/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.simplequarry.tile;

import com.mrdimka.common.util.CommonTileEntity_SQ;
import com.mrdimka.simplequarry.api.energy.IQFConsumer;
import com.mrdimka.simplequarry.api.energy.QFStorage;
import com.mrdimka.simplequarry.api.energy.UniversalConverter;
import com.mrdimka.simplequarry.api.inventory.InventoryNonTile2;
import com.mrdimka.simplequarry.net.MPCNetwork;
import com.mrdimka.simplequarry.net.TileSync;
import com.mrdimka.simplequarry.utils.ItemInsertionUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TilePoweredQuarry
extends CommonTileEntity_SQ
implements IQFConsumer {
    public QFStorage storage = new QFStorage(256000.0);
    public InventoryNonTile2 invFuel = new InventoryNonTile2(1);
    public InventoryNonTile2 invUpgrades = new InventoryNonTile2(5);
    public InventoryNonTile2 invItemList = new InventoryNonTile2(9);
    public InventoryNonTile2 invTemp = new InventoryNonTile2(64);
    public int burnTicks = 0;
    public int totalBurnTicks = 0;
    public static double BPC = 96.0;
    public int y = -1;
    public boolean collectDirt = true;
    public boolean collectCobble = true;
    public boolean listMode = false;

    @Override
    public void updateEntity() {
        int i;
        ItemStack stack;
        if (this.y == -1) {
            this.y = this.field_174879_c.func_177956_o() - 1;
        }
        Chunk c = this.field_145850_b.func_175726_f(this.field_174879_c);
        int chunkX = c.field_76635_g;
        int chunkZ = c.field_76647_h;
        double QFPerBlock = UniversalConverter.FT_QF(1600.0) / BPC;
        if (this.storage.consumeQF(null, UniversalConverter.FT_QF(1.0), true) == UniversalConverter.FT_QF(1.0) && !this.field_145850_b.field_72995_K && this.atTickRate(5) && this.burnTicks < 1 && (stack = this.invFuel.func_70301_a(0)) != null && TileEntityFurnace.func_145952_a((ItemStack)stack) > 0) {
            FluidStack fcr = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (fcr != null && FluidContainerRegistry.drainFluidContainer((ItemStack)stack) != null) {
                ItemStack ret = FluidContainerRegistry.drainFluidContainer((ItemStack)stack).func_77946_l();
                InventoryNonTile2 exportFrom = new InventoryNonTile2(1);
                exportFrom.func_70299_a(0, ret);
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    if (f == EnumFacing.DOWN) continue;
                    if (exportFrom.func_70301_a(0) == null) break;
                    ItemInsertionUtil.transferItemsOutFinal(this, exportFrom, f);
                }
                if (exportFrom.func_70301_a(0) != null && exportFrom.func_70301_a((int)0).field_77994_a > 0) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ret));
                }
            }
            this.burnTicks += TileEntityFurnace.func_145952_a((ItemStack)stack);
            this.totalBurnTicks = this.burnTicks;
            --stack.field_77994_a;
            if (stack.field_77994_a < 1) {
                this.invFuel.func_70299_a(0, null);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.burnTicks > 0) {
            int ticks = Math.min(80, this.burnTicks);
            for (int tick = 0; tick < ticks; ++tick) {
                --this.burnTicks;
                double qf = this.storage.consumeQF(null, UniversalConverter.FT_QF(1.0), true);
                if (qf != UniversalConverter.FT_QF(1.0)) continue;
                this.storage.consumeQF(null, qf, false);
            }
            TileSync.synchronize(this);
        }
        if (!this.field_145850_b.field_72995_K && this.y > 0 && this.atTickRate(10) && this.storage.getStoredQF(null) >= QFPerBlock) {
            boolean hasBrokenBlock = false;
            block2: for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    IBlockState state;
                    Block b;
                    BlockPos pos = new BlockPos(chunkX * 16 + x, this.y, chunkZ * 16 + z);
                    Block bb = this.field_145850_b.func_180495_p(pos).func_177230_c();
                    if (hasBrokenBlock || this.field_145850_b.func_175623_d(pos) || FluidRegistry.lookupFluidForBlock((Block)bb) != null || bb == Blocks.field_150356_k || bb == Blocks.field_150358_i || (b = (state = this.field_145850_b.func_180495_p(pos)).func_177230_c()).func_176195_g(state, this.field_145850_b, pos) < 0.0f) continue;
                    b.func_176226_b(this.field_145850_b, pos, state, 0);
                    this.field_145850_b.func_175698_g(pos);
                    hasBrokenBlock = true;
                    MPCNetwork.sendBlockBreakToAll(state, pos, this.field_145850_b);
                    this.storage.produceQF(null, QFPerBlock, false);
                    TileSync.synchronize(this);
                    break block2;
                }
            }
            if (!hasBrokenBlock) {
                --this.y;
            }
        }
        for (i = 0; i < this.invTemp.func_70302_i_(); ++i) {
            EntityItem item;
            int j;
            if (this.field_145850_b.field_72995_K || this.invTemp.func_70301_a(i) != null) continue;
            AxisAlignedBB aabb = new AxisAlignedBB((double)(chunkX * 16 - 1), 0.0, (double)(chunkZ * 16 - 1), (double)(chunkX * 16 + 17), (double)(this.field_174879_c.func_177956_o() + 1), (double)(chunkZ * 16 + 17));
            List items = this.field_145850_b.func_72872_a(EntityItem.class, aabb);
            for (j = 0; j < items.size(); ++j) {
                item = (EntityItem)items.get(j);
                if (item.func_92059_d() != null && item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e) && !this.collectCobble) {
                    item.func_70106_y();
                }
                if (item.func_92059_d() == null || item.func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d) || this.collectDirt) continue;
                item.func_70106_y();
            }
            items = this.field_145850_b.func_72872_a(EntityItem.class, aabb);
            for (j = 0; j < Math.min(items.size(), 1); ++j) {
                item = (EntityItem)items.get(j);
                if (item.func_92059_d().field_77994_a <= 0) continue;
                ItemStack stack2 = item.func_92059_d().func_77946_l();
                stack2.field_77994_a = 1;
                this.invTemp.func_70299_a(i, stack2);
                --item.func_92059_d().field_77994_a;
                if (item.func_92059_d().field_77994_a >= 1) continue;
                item.func_70106_y();
            }
        }
        block7: for (i = 0; i < this.invTemp.func_70302_i_(); ++i) {
            ItemStack stack3 = this.invTemp.func_70301_a(i);
            if (stack3 != null && stack3.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e) && !this.collectCobble) {
                this.invTemp.func_70299_a(i, null);
            }
            if (stack3 != null && stack3.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) && !this.collectDirt) {
                this.invTemp.func_70299_a(i, null);
                continue;
            }
            if (this.field_145850_b.field_72995_K || this.invTemp.func_70301_a(i) == null || !this.atTickRate(2)) continue;
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (f == EnumFacing.DOWN) continue;
                if (this.invTemp.func_70301_a(i) == null || this.invTemp.func_70301_a((int)i).field_77994_a < 1) continue block7;
                ItemInsertionUtil.transferItemsOutFinal(this, this.invTemp, f);
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.storage.readFromNBT(nbt);
        this.burnTicks = nbt.func_74762_e("BurnTicks");
        this.totalBurnTicks = nbt.func_74762_e("TotalBurnTicks");
        this.y = nbt.func_74762_e("MineY");
        this.invFuel.readFromNBT(nbt.func_74775_l("InventoryFuel"));
        this.invUpgrades.readFromNBT(nbt.func_74775_l("InventoryItemList"));
        this.invItemList.readFromNBT(nbt.func_74775_l("InventoryUpgrades"));
        this.invTemp.readFromNBT(nbt.func_74775_l("InventoryTemp"));
        this.collectDirt = nbt.func_74767_n("CollectDirt");
        this.collectCobble = nbt.func_74767_n("CollectCobble");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        this.storage.writeToNBT(nbt);
        nbt.func_74768_a("BurnTicks", this.burnTicks);
        nbt.func_74768_a("MineY", this.y);
        nbt.func_74768_a("TotalBurnTicks", this.totalBurnTicks);
        NBTTagCompound invTag = new NBTTagCompound();
        this.invFuel.writeToNBT(invTag);
        nbt.func_74782_a("InventoryFuel", (NBTBase)invTag);
        invTag = new NBTTagCompound();
        this.invUpgrades.writeToNBT(invTag);
        nbt.func_74782_a("InventoryUpgrades", (NBTBase)invTag);
        invTag = new NBTTagCompound();
        this.invItemList.writeToNBT(invTag);
        nbt.func_74782_a("InventoryItemList", (NBTBase)invTag);
        invTag = new NBTTagCompound();
        this.invTemp.writeToNBT(invTag);
        nbt.func_74782_a("InventoryTemp", (NBTBase)invTag);
        nbt.func_74757_a("CollectDirt", this.collectDirt);
        nbt.func_74757_a("CollectCobble", this.collectCobble);
    }

    @Override
    public boolean canConnectQF(EnumFacing to) {
        return to != EnumFacing.UP && to != EnumFacing.DOWN;
    }

    @Override
    public double getStoredQF(EnumFacing to) {
        return this.storage.getStoredQF(to);
    }

    @Override
    public double getQFCapacity(EnumFacing to) {
        return this.storage.getQFCapacity(to);
    }

    @Override
    public double consumeQF(EnumFacing from, double howMuch, boolean simulate) {
        return this.storage.consumeQF(from, howMuch, simulate);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return (int)UniversalConverter.QF_RF(this.storage.consumeQF(from, UniversalConverter.RF_QF(maxReceive), simulate));
    }

    public int getEnergyStored(EnumFacing from) {
        return (int)UniversalConverter.QF_RF(this.getStoredQF(from));
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return (int)UniversalConverter.QF_RF(this.getQFCapacity(from));
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return this.canConnectQF(from);
    }
}

