/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.simplequarry.net.pkt;

import com.mrdimka.simplequarry.client.particle.ParticleExtendedDigging;
import com.mrdimka.simplequarry.net.NetUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayBlockBreakSound
implements IMessage,
IMessageHandler<PacketPlayBlockBreakSound, PacketPlayBlockBreakSound> {
    public String soundName;
    private IBlockState s;
    private float x;
    private float y;
    private float z;
    private float volume;
    private float pitch;

    public PacketPlayBlockBreakSound() {
    }

    public PacketPlayBlockBreakSound(IBlockState state, double x, double y, double z, double volume, double pitch) {
        this.s = state;
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.volume = (float)volume;
        this.pitch = (float)pitch;
    }

    public PacketPlayBlockBreakSound(String sound, double x, double y, double z, double volume, double pitch) {
        this.soundName = sound;
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.volume = (float)volume;
        this.pitch = (float)pitch;
    }

    public PacketPlayBlockBreakSound onMessage(PacketPlayBlockBreakSound m, MessageContext c) {
        if (c.side == Side.CLIENT) {
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = new BlockPos((double)m.x, (double)m.y, (double)m.z);
            if (m.s != null) {
                ParticleManager pm = Minecraft.func_71410_x().field_71452_i;
                try {
                    if (!m.s.func_177230_c().isAir(m.s, (IBlockAccess)w, pos) && !m.s.func_177230_c().addDestroyEffects((World)w, pos, pm)) {
                        m.s = m.s.func_185899_b((IBlockAccess)w, pos);
                        int i = 4;
                        for (int j = 0; j < i; ++j) {
                            for (int k = 0; k < i; ++k) {
                                for (int l = 0; l < i; ++l) {
                                    double d0 = (double)m.x + ((double)j + 0.5) / (double)i;
                                    double d1 = (double)m.y + ((double)k + 0.5) / (double)i;
                                    double d2 = (double)m.z + ((double)l + 0.5) / (double)i;
                                    pm.func_78873_a((Particle)new ParticleExtendedDigging((World)w, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, m.s).func_174846_a(pos));
                                }
                            }
                        }
                    }
                }
                catch (Throwable err) {
                    err.printStackTrace();
                }
            }
        }
        return null;
    }

    public void fromBytes(ByteBuf b) {
        if (b.readBoolean()) {
            this.s = Block.func_176220_d((int)b.readInt());
        }
        if (b.readBoolean()) {
            this.soundName = new String(NetUtil.readByteArray(b));
        }
        this.x = b.readFloat();
        this.y = b.readFloat();
        this.z = b.readFloat();
        this.volume = b.readFloat();
        this.pitch = b.readFloat();
    }

    public void toBytes(ByteBuf b) {
        b.writeBoolean(this.s != null);
        if (this.s != null) {
            b.writeInt(Block.func_176210_f((IBlockState)this.s));
        }
        b.writeBoolean(this.soundName != null);
        if (this.soundName != null) {
            NetUtil.writeByteArray(this.soundName.getBytes(), b);
        }
        b.writeFloat(this.x);
        b.writeFloat(this.y);
        b.writeFloat(this.z);
        b.writeFloat(this.volume);
        b.writeFloat(this.pitch);
    }
}

