/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.simplequarry.init;

import com.mrdimka.simplequarry.SimpleQuarry;
import com.mrdimka.simplequarry.init.Base64;
import com.mrdimka.simplequarry.utils.ArrayHashSet;
import com.mrdimka.simplequarry.utils.StringToItemStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import json.JSONArray;
import json.JSONObject;
import json.JSONTokener;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeIO {
    public static final String RECIPES = "Ww0KCXsNCgkJInJlc3VsdCI6ICJzaW1wbGVxdWFycnk6ZnVlbF9xdWFycnk6MEAxIiwNCgkJInBhdHRlcm4iOiBbInBpcCIsICJmZ2YiLCAicGRwIl0sDQoJCSJpbmdyZWRpZW50cyI6IFsicCIsICIjbWluZWNyYWZ0OmVuZGVyX3BlYXJsOjBAMSIsICJpIiwgIiNtaW5lY3JhZnQ6aXJvbl9waWNrYXhlOjBAMSIsICJmIiwgIiNtaW5lY3JhZnQ6ZnVybmFjZTowQDEiLCAiZyIsICIjbWluZWNyYWZ0OmdvbGRlbl9waWNrYXhlOjBAMSIsICJkIiwgIiNtaW5lY3JhZnQ6ZGlhbW9uZF9waWNrYXhlOjBAMSJdDQoJfQ0KXQ==";
    public static ArrayHashSet<ShapedOreRecipe> recipesReg = new ArrayHashSet();

    public static String getRecipesJSON() {
        File f = new File(SimpleQuarry.cfgFolder, "recipes.json");
        if (!f.exists()) {
            RecipeIO.flush(null);
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            fis.close();
            return new String(b);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void flush(String json) {
        if (json == null) {
            json = new String(Base64.decode(RECIPES));
        }
        File f = new File(SimpleQuarry.cfgFolder, "recipes.json");
        try {
            if (!f.exists()) {
                f.mkdirs();
                f.delete();
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(json.getBytes());
            fos.flush();
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reload() {
        JSONArray arr = null;
        try {
            arr = (JSONArray)new JSONTokener(RecipeIO.getRecipesJSON()).nextValue();
        }
        catch (Throwable err) {
            // empty catch block
        }
        if (arr == null) {
            return;
        }
        for (Object o : recipesReg.toArray()) {
            CraftingManager.func_77594_a().func_77592_b().remove(o);
        }
        for (int i = 0; i < arr.length(); ++i) {
            try {
                JSONObject obj = arr.getJSONObject(i);
                ArrayList<Object> objs = new ArrayList<Object>();
                JSONArray pattern = obj.getJSONArray("pattern");
                for (int j = 0; j < pattern.length(); ++j) {
                    objs.add(pattern.getString(j));
                }
                JSONArray ingredients = obj.getJSONArray("ingredients");
                for (int j = 0; j < ingredients.length(); j += 2) {
                    char k = ingredients.getString(j).charAt(0);
                    String s = ingredients.getString(j + 1);
                    ItemStack parsed = s.charAt(0) == '#' ? StringToItemStack.toItemStack(s.substring(1), null) : null;
                    objs.add(Character.valueOf(k));
                    objs.add(parsed != null ? parsed : s);
                }
                ShapedOreRecipe sor = new ShapedOreRecipe(StringToItemStack.toItemStack(obj.getString("result"), null), objs.toArray());
                recipesReg.add(sor);
                CraftingManager.func_77594_a().func_180302_a((IRecipe)sor);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

