/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.simplequarry;

import com.mrdimka.simplequarry.api.energy.UniversalConverter;
import com.mrdimka.simplequarry.gui.GuiHandler;
import com.mrdimka.simplequarry.gui.c.ContainerFuelQuarry;
import com.mrdimka.simplequarry.gui.c.ContainerPoweredQuarry;
import com.mrdimka.simplequarry.init.ModBlocks;
import com.mrdimka.simplequarry.init.ModItems;
import com.mrdimka.simplequarry.init.RecipeIO;
import com.mrdimka.simplequarry.proxy.CommonProxy;
import com.mrdimka.simplequarry.tile.TileFuelQuarry;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="simplequarry", name="Simple Quarry", version="1.9.4_1.0.0", acceptedMinecraftVersions="[1.9.4]")
public class SimpleQuarry {
    @SidedProxy(modId="simplequarry", clientSide="com.mrdimka.simplequarry.proxy.ClientProxy", serverSide="com.mrdimka.simplequarry.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="simplequarry")
    public static SimpleQuarry instance;
    public static File cfgFolder;
    public static final CreativeTabs tab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        String cfg = e.getSuggestedConfigurationFile().getAbsolutePath();
        cfg = cfg.substring(0, cfg.length() - 3);
        cfgFolder = new File(cfg);
        cfgFolder.mkdirs();
        proxy.preInit();
        RecipeIO.reload();
        new ModItems();
        new ModBlocks();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        proxy.serverStarting();
        RecipeIO.reload();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent e) {
        proxy.serverStarted();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent e) {
        proxy.serverStopping();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent e) {
        proxy.serverStopped();
    }

    @SubscribeEvent
    public void tooltip(ItemTooltipEvent e) {
        EntityPlayer p = e.getEntityPlayer();
        if (p.field_71070_bA instanceof ContainerFuelQuarry || p.field_71070_bA instanceof ContainerPoweredQuarry) {
            int burnTime = TileEntityFurnace.func_145952_a((ItemStack)e.getItemStack());
            if (burnTime > 0) {
                e.getToolTip().add("\u00a78" + I18n.func_74838_a((String)"info.simplequarry:blocks_broken") + ": " + (int)(UniversalConverter.FT_QF(burnTime) / (UniversalConverter.FT_QF(1600.0) / TileFuelQuarry.BPC)));
            } else {
                e.getToolTip().add("\u00a78" + I18n.func_74838_a((String)"info.simplequarry:not_fuel"));
            }
        }
    }

    static {
        tab = new CreativeTabs("simplequarry"){
            private int tick = 0;
            private int index = 0;

            public ItemStack func_151244_d() {
                ArrayList items = new ArrayList();
                this.func_78018_a(items);
                if (this.tick++ > 150) {
                    this.tick = 0;
                    ++this.index;
                }
                if (this.index >= items.size()) {
                    this.index = 0;
                }
                return (ItemStack)items.get(this.index);
            }

            public Item func_78016_d() {
                return this.func_151244_d().func_77973_b();
            }
        };
    }
}

