/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.util;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class BlockHelper {
    public static byte[] rotateType = new byte[4096];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static float[][] SIDE_COORD_AABB = new float[][]{{1.0f, -2.0f, 1.0f}, {1.0f, 2.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 2.0f}, {1.0f, 1.0f, 1.0f}, {2.0f, 1.0f, 1.0f}};
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};
    public static final byte[] ROTATE_CLOCK_Y = new byte[]{0, 1, 4, 5, 3, 2};
    public static final byte[] ROTATE_CLOCK_Z = new byte[]{5, 4, 2, 3, 0, 1};
    public static final byte[] ROTATE_CLOCK_X = new byte[]{2, 3, 1, 0, 4, 5};
    public static final byte[] ROTATE_COUNTER_Y = new byte[]{0, 1, 5, 4, 2, 3};
    public static final byte[] ROTATE_COUNTER_Z = new byte[]{4, 5, 2, 3, 1, 0};
    public static final byte[] ROTATE_COUNTER_X = new byte[]{3, 2, 0, 1, 4, 5};
    public static final byte[] INVERT_AROUND_Y = new byte[]{0, 1, 3, 2, 5, 4};
    public static final byte[] INVERT_AROUND_Z = new byte[]{1, 0, 2, 3, 5, 4};
    public static final byte[] INVERT_AROUND_X = new byte[]{1, 0, 3, 2, 4, 5};
    public static final byte[][] ICON_ROTATION_MAP = new byte[6][];

    private BlockHelper() {
    }

    public static int determineXZPlaceFacing(EntityLivingBase living) {
        int quadrant = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 3;
    }

    public static boolean isEqual(Block blockA, Block blockB) {
        if (blockA == blockB) {
            return true;
        }
        if (blockA == null | blockB == null) {
            return false;
        }
        return blockA.equals(blockB) || blockA.func_149667_c(blockB);
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, EnumFacing dir) {
        return world == null ? null : world.func_175625_s(new BlockPos(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e()));
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, int side) {
        return world == null ? null : BlockHelper.getAdjacentTileEntity(world, x, y, z, EnumFacing.values()[side]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, EnumFacing dir) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.func_174877_v().func_177958_n(), refTile.func_174877_v().func_177956_o(), refTile.func_174877_v().func_177952_p(), dir);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, int side) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.func_174877_v().func_177958_n(), refTile.func_174877_v().func_177956_o(), refTile.func_174877_v().func_177952_p(), EnumFacing.values()[side]);
    }

    public static int determineAdjacentSide(TileEntity refTile, int x, int y, int z) {
        return y > refTile.func_174877_v().func_177956_o() ? 1 : (y < refTile.func_174877_v().func_177956_o() ? 0 : (z > refTile.func_174877_v().func_177952_p() ? 3 : (z < refTile.func_174877_v().func_177952_p() ? 2 : (x > refTile.func_174877_v().func_177958_n() ? 5 : 4))));
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }

    public static int getLeftSide(int side) {
        return SIDE_LEFT[side];
    }

    public static int getRightSide(int side) {
        return SIDE_RIGHT[side];
    }

    public static int getOppositeSide(int side) {
        return SIDE_OPPOSITE[side];
    }

    public static int getAboveSide(int side) {
        return SIDE_ABOVE[side];
    }

    public static int getBelowSide(int side) {
        return SIDE_BELOW[side];
    }

    public static boolean canRotate(Block block) {
        return rotateType[Block.func_149682_b((Block)block)] != 0;
    }

    public static int rotateVanillaBlock(World world, Block block, int x, int y, int z) {
        int bId = Block.func_149682_b((Block)block);
        int bMeta = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_176201_c(world.func_180495_p(new BlockPos(x, y, z)));
        switch (rotateType[bId]) {
            case 1: {
                return SIDE_LEFT[bMeta];
            }
            case 2: {
                if (bMeta < 6) {
                    return ++bMeta % 6;
                }
                return bMeta;
            }
            case 3: {
                if (bMeta < 2) {
                    return ++bMeta % 2;
                }
                return bMeta;
            }
            case 4: {
                return ++bMeta % 4;
            }
            case 5: {
                return ++bMeta % 8;
            }
            case 6: {
                int upper = bMeta & 0xC;
                int lower = bMeta & 3;
                return upper + ++lower % 4;
            }
            case 7: {
                return (bMeta + 4) % 12;
            }
            case 8: {
                return (bMeta + 8) % 16;
            }
            case 10: {
                int shift = 0;
                if (bMeta > 7) {
                    bMeta -= 8;
                    shift = 8;
                }
                if (bMeta == 5) {
                    return 6 + shift;
                }
                if (bMeta == 6) {
                    return 5 + shift;
                }
                if (bMeta == 7) {
                    return 0 + shift;
                }
                if (bMeta == 0) {
                    return 7 + shift;
                }
                return bMeta + shift;
            }
            case 11: {
                return ++bMeta % 16;
            }
        }
        return bMeta;
    }

    public static int rotateVanillaBlockAlt(World world, Block block, int x, int y, int z) {
        int bId = Block.func_149682_b((Block)block);
        int bMeta = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_176201_c(world.func_180495_p(new BlockPos(x, y, z)));
        switch (rotateType[bId]) {
            case 1: {
                return SIDE_RIGHT[bMeta];
            }
            case 2: {
                if (bMeta < 6) {
                    return (bMeta + 5) % 6;
                }
                return bMeta;
            }
            case 3: {
                if (bMeta < 2) {
                    return ++bMeta % 2;
                }
                return bMeta;
            }
            case 4: {
                return (bMeta + 3) % 4;
            }
            case 5: {
                return (bMeta + 7) % 8;
            }
            case 6: {
                int upper = bMeta & 0xC;
                int lower = bMeta & 3;
                return upper + (lower + 3) % 4;
            }
            case 7: {
                return (bMeta + 8) % 12;
            }
            case 8: {
                return (bMeta + 8) % 16;
            }
            case 10: {
                int shift = 0;
                if (bMeta > 7) {
                    bMeta -= 8;
                    shift = 8;
                }
                if (bMeta == 5) {
                    return 6 + shift;
                }
                if (bMeta == 6) {
                    return 5 + shift;
                }
                if (bMeta == 7) {
                    return 0 + shift;
                }
                if (bMeta == 0) {
                    return 7 + shift;
                }
            }
            case 11: {
                return ++bMeta % 16;
            }
        }
        return bMeta;
    }

    public static ItemStack createStackedBlock(Block block, int bMeta) {
        Item item = Item.func_150898_a((Block)block);
        if (item.func_77614_k()) {
            return new ItemStack(item, 1, bMeta);
        }
        return new ItemStack(item, 1, 0);
    }

    static {
        BlockHelper.ICON_ROTATION_MAP[0] = new byte[]{0, 1, 2, 3, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[1] = new byte[]{1, 0, 2, 3, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[2] = new byte[]{3, 2, 0, 1, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[3] = new byte[]{3, 2, 1, 0, 5, 4};
        BlockHelper.ICON_ROTATION_MAP[4] = new byte[]{3, 2, 5, 4, 0, 1};
        BlockHelper.ICON_ROTATION_MAP[5] = new byte[]{3, 2, 4, 5, 1, 0};
    }

    public static final class RotationType {
        public static final int PREVENT = -1;
        public static final int FOUR_WAY = 1;
        public static final int SIX_WAY = 2;
        public static final int RAIL = 3;
        public static final int PUMPKIN = 4;
        public static final int STAIRS = 5;
        public static final int REDSTONE = 6;
        public static final int LOG = 7;
        public static final int SLAB = 8;
        public static final int CHEST = 9;
        public static final int LEVER = 10;
        public static final int SIGN = 11;
    }
}

