/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.items;

import cofh.api.energy.IEnergyContainerItem;
import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.items.BaseItem;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemRFEngine
extends BaseItem
implements IEnergyContainerItem {
    protected int maxCharge = 100000;
    private static DecimalFormat rfDecimalFormat = new DecimalFormat("###,###,###,###,###");

    public ItemRFEngine() {
        super("RFEngine");
        this.func_77625_d(1);
        this.setMaxCharge(PAConfig.rfStored);
    }

    public ItemRFEngine(String name) {
        super(name);
    }

    public void setMaxCharge(int amount) {
        this.maxCharge = amount;
    }

    public int getMaxCharge() {
        return this.maxCharge;
    }

    public int getCharge(ItemStack itemStack) {
        this.initNBT(itemStack);
        return itemStack.func_77978_p().func_74762_e("charge");
    }

    public void setCharge(ItemStack itemStack, int charge) {
        this.initNBT(itemStack);
        itemStack.func_77978_p().func_74768_a("charge", charge);
    }

    public int addCharge(ItemStack itemStack, int amount) {
        int amountUsed = amount;
        int current = this.getCharge(itemStack);
        if (current + amount > this.maxCharge) {
            amountUsed = this.maxCharge - current;
        }
        if (current + amount < 0) {
            amountUsed = current;
        }
        if ((current += amount) >= this.maxCharge) {
            current = this.maxCharge;
        }
        if (current < 0) {
            current = 0;
        }
        this.setCharge(itemStack, current);
        return amountUsed;
    }

    protected void initNBT(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74768_a("charge", 0);
        }
    }

    protected boolean isInit(ItemStack itemStack) {
        return itemStack.func_77978_p() != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par) {
        if (itemStack != null && this.isInit(itemStack)) {
            int charge = this.getCharge(itemStack);
            list.add(TextFormatting.RED + "" + String.format("%s", rfDecimalFormat.format(charge)) + "/" + String.format("%s", rfDecimalFormat.format(this.maxCharge)) + " RF");
        } else {
            list.add(TextFormatting.GRAY + "Add to the fuel slot to");
            list.add(TextFormatting.GRAY + "power a machine with RF");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack itemStack) {
        return this.isInit(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - (double)this.getCharge(itemStack) / (double)this.maxCharge;
    }

    @Override
    protected void addNormalRecipe() {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack((Item)this), new Object[]{"iii", "grg", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('r'), Blocks.field_150451_bX, Character.valueOf('g'), Items.field_151043_k});
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    @Override
    protected void addUpgradeRecipe() {
        this.addNormalRecipe();
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int maxReceive, boolean simulate) {
        if (simulate) {
            return maxReceive;
        }
        return this.addCharge(itemStack, maxReceive);
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int maxExtract, boolean simulate) {
        if (simulate) {
            return maxExtract;
        }
        return this.addCharge(itemStack, maxExtract * -1);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return this.getCharge(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxCharge();
    }
}

