/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.killer.TileKiller;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerKiller;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIKiller
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Killer.png");
    protected int infoScreenX = 38;
    protected int infoScreenW = 66;
    protected int infroScreenY1 = 17;
    protected int infroScreenY2 = 27;
    protected int infroScreenY3 = 37;
    TileKiller killer;

    public GUIKiller(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerKiller(inv, entity), texture);
        this.killer = (TileKiller)entity;
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.killer"), 5, GRAY);
        this.drawString(StringHelper.localize("gui.range") + ": " + StringHelper.getScaledNumber(this.killer.getRange()), this.infoScreenX, this.infoScreenW, this.infroScreenY3, this.killer.hasUpgrade(UpgradeType.WITHER) ? GREEN : WHITE);
        if (this.killer.isInvalidTool()) {
            this.drawString(this.getTextLine(1, "gui.invalidtool.1"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, ORANGE);
            this.drawString(this.getTextLine(2, "gui.invalidtool.2"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, ORANGE);
        } else if (this.killer.isLooked()) {
            boolean readyToPlant = false;
            if (!this.killer.hasFuel() && !this.killer.isBurning()) {
                String fuelString = "gui.need.fuel";
                if (this.killer.hasEngine()) {
                    fuelString = "gui.need.energy";
                }
                this.drawString(StringHelper.localize(fuelString), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (this.killer.func_70301_a(this.killer.SLOT_SWORD) == null) {
                this.drawString(StringHelper.localize("gui.need.sword"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else {
                readyToPlant = true;
                String status = "gui.waiting";
                if (this.killer.isKilling()) {
                    status = "gui.killing";
                }
                this.drawString(StringHelper.localize(status), this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
            }
            if (!readyToPlant) {
                this.drawString(StringHelper.localize("gui.notready"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
            } else if (this.killer.isBurning()) {
                this.drawString(StringHelper.localize("gui.running"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
            } else {
                this.drawString(StringHelper.localize("gui.waiting"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            }
        } else {
            this.drawString(this.getTextLine(1, "gui.hi.killer"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            this.drawString(this.getTextLine(2, "gui.addtools"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.killer.getPercentDone(), 10, 22);
    }
}

