/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.farmer.TileFarmer;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerFarmer;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIFarmer
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Farmer.png");
    protected int infoScreenX = 38;
    protected int infoScreenW = 66;
    protected int infroScreenY1 = 17;
    protected int infroScreenY2 = 27;
    protected int infroScreenY3 = 37;
    TileFarmer farmer;

    public GUIFarmer(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerFarmer(inv, entity), texture);
        this.farmer = (TileFarmer)entity;
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.farmer"), 5, GRAY);
        this.drawString(StringHelper.localize("gui.range") + ": " + StringHelper.getScaledNumber(this.farmer.getRange()), this.infoScreenX, this.infoScreenW, this.infroScreenY3, this.farmer.hasUpgrade(UpgradeType.WITHER) ? GREEN : WHITE);
        if (this.farmer.isInvalidTool()) {
            this.drawString(this.getTextLine(1, "gui.invalidtool.1"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, ORANGE);
            this.drawString(this.getTextLine(2, "gui.invalidtool.2"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, ORANGE);
        } else if (this.farmer.isLooked()) {
            boolean allGood = false;
            if (!this.farmer.hasFuel() && !this.farmer.isBurning()) {
                String fuelString = "gui.need.fuel";
                if (this.farmer.hasEngine()) {
                    fuelString = "gui.need.energy";
                }
                this.drawString(StringHelper.localize(fuelString), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else if (this.farmer.func_70301_a(this.farmer.SLOT_FOOD) == null && this.farmer.func_70301_a(this.farmer.SLOT_BUCKETS) == null && this.farmer.func_70301_a(this.farmer.SLOT_SHEARS) == null) {
                this.drawString(StringHelper.localize("gui.need.items"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
            } else {
                allGood = true;
                String status = "gui.waiting";
                if (this.farmer.getCurrentAction() == 1) {
                    status = "gui.breeding";
                } else if (this.farmer.getCurrentAction() == 2) {
                    status = "gui.shearing";
                } else if (this.farmer.getCurrentAction() == 3) {
                    status = "gui.milking";
                }
                this.drawString(StringHelper.localize(status), this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
            }
            if (!allGood) {
                this.drawString(StringHelper.localize("gui.notready"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
            } else if (this.farmer.isBurning()) {
                this.drawString(StringHelper.localize("gui.running"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
            } else {
                this.drawString(StringHelper.localize("gui.waiting"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            }
        } else {
            this.drawString(this.getTextLine(1, "gui.hi.farmer"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            this.drawString(this.getTextLine(2, "gui.addtools"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.farmer.getPercentDone(), 10, 34);
        if (this.farmer.hasUpgrade(UpgradeType.SHEARING)) {
            this.func_73729_b(this.field_147003_i + 36, this.field_147009_r + 51, 238, 18, 18, 18);
        }
        if (this.farmer.hasUpgrade(UpgradeType.MILKER)) {
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 51, 238, 0, 18, 18);
        }
    }
}

