/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat.mods;

import com.vanhal.progressiveautomation.ProgressiveAutomation;
import com.vanhal.progressiveautomation.compat.BaseMod;
import com.vanhal.progressiveautomation.util.OreHelper;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class Vanilla
extends BaseMod {
    @Override
    public boolean shouldLoad() {
        this.modID = "Vanilla";
        ProgressiveAutomation.logger.info("Vanilla Loaded");
        return true;
    }

    @Override
    public boolean isSapling(ItemStack stack) {
        return OreHelper.testOre("treeSapling", stack);
    }

    @Override
    public boolean isPlantible(ItemStack item) {
        if (item.func_77973_b() instanceof IPlantable) {
            return true;
        }
        if (item.func_77973_b() == Items.field_151120_aE) {
            return true;
        }
        return Block.func_149634_a((Item)item.func_77973_b()) == Blocks.field_150434_aF;
    }

    @Override
    public boolean shouldHoe(ItemStack item) {
        return item.func_77973_b() instanceof IPlantable;
    }

    @Override
    public boolean isPlant(Block plantBlock, IBlockState state) {
        if (plantBlock instanceof IGrowable) {
            return true;
        }
        if (plantBlock instanceof BlockNetherWart) {
            return true;
        }
        if (plantBlock == Blocks.field_150436_aH) {
            return true;
        }
        return plantBlock == Blocks.field_150434_aF;
    }

    @Override
    public boolean isGrown(Point3I plantPoint, Block plantBlock, IBlockState state, World worldObj) {
        int metadata = plantBlock.func_176201_c(state);
        if (plantBlock instanceof IGrowable) {
            return !((IGrowable)plantBlock).func_176473_a(worldObj, plantPoint.toPosition(), state, true);
        }
        if (plantBlock instanceof BlockNetherWart) {
            return metadata >= 3;
        }
        if (plantBlock == Blocks.field_150436_aH) {
            return worldObj.func_180495_p(plantPoint.toPosition().func_177984_a()).func_177230_c() == Blocks.field_150436_aH;
        }
        if (plantBlock == Blocks.field_150434_aF) {
            return worldObj.func_180495_p(plantPoint.toPosition().func_177984_a()).func_177230_c() == Blocks.field_150434_aF;
        }
        return false;
    }

    protected IBlockState getPlantBlock(World worldObj, ItemStack itemStack, Point3I point) {
        IBlockState plant = null;
        if (itemStack.func_77973_b() instanceof IPlantable) {
            plant = ((IPlantable)itemStack.func_77973_b()).getPlant((IBlockAccess)worldObj, point.toPosition());
        } else if (itemStack.func_77973_b() == Items.field_151120_aE) {
            plant = Blocks.field_150436_aH.func_176223_P();
        } else if (Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150434_aF) {
            plant = Blocks.field_150434_aF.func_176223_P();
        }
        return plant;
    }

    @Override
    public boolean validBlock(World worldObj, ItemStack itemStack, Point3I point) {
        IBlockState plant = this.getPlantBlock(worldObj, itemStack, point);
        if (plant != null) {
            return plant.func_177230_c().func_176196_c(worldObj, point.toPosition()) && worldObj.func_180495_p(point.toPosition()).func_177230_c() != plant.func_177230_c();
        }
        return false;
    }

    @Override
    public boolean placeSeed(World worldObj, ItemStack itemStack, Point3I point, boolean doAction) {
        IBlockState plant = this.getPlantBlock(worldObj, itemStack, point);
        if (plant != null) {
            if (doAction) {
                worldObj.func_180501_a(point.toPosition(), plant.func_177230_c().func_176203_a(itemStack.func_77973_b().getDamage(itemStack)), 7);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> harvestPlant(Point3I plantPoint, Block plantBlock, IBlockState state, World worldObj) {
        if (plantBlock == Blocks.field_150436_aH || plantBlock == Blocks.field_150434_aF) {
            plantPoint.setY(plantPoint.getY() + 1);
            state = worldObj.func_180495_p(plantPoint.toPosition());
            plantBlock = state.func_177230_c();
        }
        return super.harvestPlant(plantPoint, plantBlock, state, worldObj);
    }
}

