/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat;

import com.vanhal.progressiveautomation.compat.BaseMod;
import com.vanhal.progressiveautomation.compat.mods.MFR;
import com.vanhal.progressiveautomation.compat.mods.RightClick;
import com.vanhal.progressiveautomation.compat.mods.Vanilla;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ModHelper {
    private static ArrayList<BaseMod> modsLoaded = new ArrayList();

    private static void registerMods() {
        ModHelper.registerMod(new MFR());
        ModHelper.registerMod(new RightClick());
        ModHelper.registerMod(new Vanilla());
    }

    public static void registerMod(BaseMod mod) {
        if (mod.shouldLoad()) {
            modsLoaded.add(mod);
        }
    }

    public static void init() {
        ModHelper.registerMods();
    }

    public static boolean checkSapling(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isSapling(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlantible(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlantible(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isLog(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLeaf(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isLeaf(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldHoe(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlantible(item)) continue;
            return mod.shouldHoe(item);
        }
        return false;
    }

    public static boolean isPlant(Block plantBlock, IBlockState state) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlant(plantBlock, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrown(Point3I plantPoint, Block plantBlock, IBlockState state, World worldObj) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlant(plantBlock, state) || !mod.isGrown(plantPoint, plantBlock, state, worldObj)) continue;
            return true;
        }
        return false;
    }

    public static boolean validBlock(World worldObj, ItemStack itemStack, Point3I testPoint) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.validBlock(worldObj, itemStack, testPoint)) continue;
            return true;
        }
        return false;
    }

    public static boolean placeSeed(World worldObj, ItemStack itemStack, Point3I testPoint, boolean doAction) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.validBlock(worldObj, itemStack, testPoint) || !mod.placeSeed(worldObj, itemStack, testPoint, doAction)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> harvestPlant(Point3I plantPoint, Block plantBlock, IBlockState state, World worldObj) {
        List<ItemStack> items = null;
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlant(plantBlock, state) || !mod.isGrown(plantPoint, plantBlock, state, worldObj) || (items = mod.harvestPlant(plantPoint, plantBlock, state, worldObj)) == null) continue;
            return items;
        }
        return null;
    }
}

