/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.blocks.network;

import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PartialTileNBTUpdateMessage
implements IMessage {
    int x;
    int y;
    int z;
    NBTTagCompound nbtTag;

    public PartialTileNBTUpdateMessage() {
    }

    public PartialTileNBTUpdateMessage(int x, int y, int z, NBTTagCompound nbtTag) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.nbtTag = nbtTag;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.nbtTag = PartialTileNBTUpdateMessage.readNBTTagCompoundFromBuffer(buf);
        }
        catch (IOException exception) {
            throw new IllegalStateException("The impossible has happened!", exception);
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            PartialTileNBTUpdateMessage.writeNBTTagCompoundToBuffer(buf, this.nbtTag);
        }
        catch (IOException exception) {
            throw new IllegalStateException("The impossible has happened!", exception);
        }
    }

    private static void writeNBTTagCompoundToBuffer(ByteBuf buf, NBTTagCompound tag) throws IOException {
        if (tag == null) {
            buf.writeShort(-1);
        } else {
            byte[] abyte = PartialTileNBTUpdateMessage.compress(tag);
            buf.writeShort((int)((short)abyte.length));
            buf.writeBytes(abyte);
        }
    }

    private static NBTTagCompound readNBTTagCompoundFromBuffer(ByteBuf buf) throws IOException {
        short short1 = buf.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        buf.readBytes(abyte);
        return PartialTileNBTUpdateMessage.decompress(abyte, new NBTSizeTracker(0x200000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compress(NBTTagCompound p_74798_0_) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)p_74798_0_, (DataOutput)dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
        return bytearrayoutputstream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound decompress(byte[] p_152457_0_, NBTSizeTracker p_152457_1_) throws IOException {
        NBTTagCompound nbttagcompound;
        DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(p_152457_0_))));
        try {
            nbttagcompound = CompressedStreamTools.func_152456_a((DataInput)datainputstream, (NBTSizeTracker)p_152457_1_);
        }
        finally {
            datainputstream.close();
        }
        return nbttagcompound;
    }
}

