/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.block.IEnergyBattery;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectable;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyProvider", modid="CoFHAPI", striprefs=true), @Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI", striprefs=true)})
public class TileEnergyBattery
extends TileCableConnectable
implements IEnergyBattery,
IEnergyProvider,
IEnergyReceiver {
    @NBTPersist
    private int energy;

    protected boolean isCreative() {
        return ((BlockEnergyBatteryBase)this.getBlock()).isCreative();
    }

    @Override
    public DimPos getPosition() {
        return DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    @Override
    public int getStoredEnergy() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.energy;
    }

    @Override
    public int getMaxStoredEnergy() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return BlockEnergyBatteryConfig.capacity;
    }

    public void updateBlockState() {
        IBlockState blockState;
        if (!this.isCreative() && (blockState = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() == BlockEnergyBattery.getInstance()) {
            int fill = (int)Math.floor((float)this.energy * (float)(BlockEnergyBattery.FILL.func_177700_c().size() - 1) / (float)this.getMaxStoredEnergy());
            this.func_145831_w().func_175656_a(this.func_174877_v(), blockState.func_177226_a((IProperty)BlockEnergyBattery.FILL, (Comparable)Integer.valueOf(fill)));
        }
    }

    protected void setEnergy(int energy) {
        if (!this.isCreative()) {
            this.energy = energy;
            this.updateBlockState();
            this.sendUpdate();
        }
    }

    @Override
    public int addEnergy(int energy, boolean simulate) {
        if (!this.isCreative()) {
            int stored = this.getStoredEnergy();
            int newEnergy = Math.min(stored + energy, this.getMaxStoredEnergy());
            if (!simulate) {
                this.setEnergy(newEnergy);
            }
            return newEnergy - stored;
        }
        return 0;
    }

    @Override
    public int consume(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        int stored = this.getStoredEnergy();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.consume(maxExtract, simulate);
    }

    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(EnumFacing from) {
        return this.getStoredEnergy();
    }

    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxStoredEnergy();
    }

    @Optional.Method(modid="CoFHAPI")
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.addEnergy(maxReceive, simulate);
    }
}

