/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.block.property.ExtendedBlockStateBuilder;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableFacadeable;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableNetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkComponent;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class TileMultipartTicking
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile,
IPartContainer,
ITileCableNetwork,
ITileCableFacadeable,
PartHelpers.IPartStateHolderCallback {
    private final EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> partData = EnumFacingMap.newMap();
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private boolean realCable = true;
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> redstoneLevels = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneInputs = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lightLevels = EnumFacingMap.newMap();
    private EnumFacingMap<Integer> previousLightLevels;
    @NBTPersist
    private String facadeBlockName = null;
    @NBTPersist
    private int facadeMeta = 0;
    private IPartNetwork network;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.func_70296_d();
        tag = super.func_189515_b(tag);
        PartHelpers.writePartsToNBT(this.func_174877_v(), tag, this.partData);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        EnumFacingMap<Boolean> lastConnected = this.connected;
        String lastFacadeBlockName = this.facadeBlockName;
        int lastFacadeMeta = this.facadeMeta;
        PartHelpers.readPartsFromNBT(this.getNetwork(), this.func_174877_v(), tag, this.partData, this.func_145831_w());
        super.func_145839_a(tag);
        if (!(this.func_145831_w() == null || lastConnected != null && this.connected != null && lastConnected.equals(this.connected) && Objects.equals(lastFacadeBlockName, this.facadeBlockName) && lastFacadeMeta == this.facadeMeta)) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void setRealCable(boolean realCable) {
        this.realCable = realCable;
        this.sendUpdate();
    }

    public boolean isRealCable() {
        return this.realCable;
    }

    @Override
    public DimPos getPosition() {
        return DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    @Override
    public Map<EnumFacing, IPartType<?, ?>> getParts() {
        return Maps.transformValues(this.partData, (Function)new Function<PartHelpers.PartStateHolder<?, ?>, IPartType<?, ?>>(){

            @Nullable
            public IPartType<?, ?> apply(@Nullable PartHelpers.PartStateHolder<?, ?> input) {
                return input.getPart();
            }
        });
    }

    @Override
    public boolean hasParts() {
        return !this.partData.isEmpty();
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean canAddPart(EnumFacing side, IPartType<P, S> part) {
        return !this.hasPart(side);
    }

    protected void onPartsChanged() {
        this.func_70296_d();
        this.sendUpdate();
    }

    public void setPart(final EnumFacing side, final IPartType part, final IPartState partState) {
        PartHelpers.setPart(this.getNetwork(), this.func_145831_w(), this.func_174877_v(), side, Objects.requireNonNull(part), Objects.requireNonNull(partState), new PartHelpers.IPartStateHolderCallback(){

            @Override
            public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                TileMultipartTicking.this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(part, partState));
            }
        });
        this.onPartsChanged();
    }

    @Override
    public IPartType getPart(EnumFacing side) {
        if (!this.partData.containsKey((Object)side)) {
            return null;
        }
        return ((PartHelpers.PartStateHolder)this.partData.get((Object)side)).getPart();
    }

    @Override
    public boolean hasPart(EnumFacing side) {
        return this.partData.containsKey((Object)side);
    }

    @Override
    public IPartType removePart(EnumFacing side, EntityPlayer player) {
        PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
        if (partStateHolder == null) {
            IntegratedDynamics.clog(Level.WARN, "Attempted to remove a part at a side where no part was.");
            return null;
        }
        IPartType removed = partStateHolder.getPart();
        if (this.getNetwork() != null) {
            INetworkElement<IPartNetwork> networkElement = removed.createNetworkElement((IPartContainerFacade)this.getBlock(), DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v()), side);
            networkElement.onPreRemoved(this.getNetwork());
            if (!this.getNetwork().removeNetworkElementPre(networkElement)) {
                return null;
            }
            LinkedList itemStacks = Lists.newLinkedList();
            networkElement.addDrops(itemStacks, true);
            for (ItemStack itemStack : itemStacks) {
                if (player != null) {
                    ItemStackHelpers.spawnItemStackToPlayer((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (ItemStack)itemStack, (EntityPlayer)player);
                    continue;
                }
                Block.func_180635_a((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (ItemStack)itemStack);
            }
            this.getNetwork().removeNetworkElementPost(networkElement);
            networkElement.onPostRemoved(this.getNetwork());
        } else {
            IntegratedDynamics.clog(Level.WARN, "Removing a part where no network reference was found.");
            ItemStackHelpers.spawnItemStackToPlayer((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (ItemStack)new ItemStack(removed.getItem()), (EntityPlayer)player);
        }
        IPartType ret = ((PartHelpers.PartStateHolder)this.partData.remove((Object)side)).getPart();
        this.onPartsChanged();
        return ret;
    }

    @Override
    public void setPartState(EnumFacing side, IPartState partState) {
        PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
        if (partStateHolder == null) {
            throw new IllegalArgumentException(String.format("No part at position %s was found to update the state for.", this.getPosition()));
        }
        this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(partStateHolder.getPart(), partState));
        this.onPartsChanged();
    }

    @Override
    public IPartState getPartState(EnumFacing side) {
        PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
        if (partStateHolder == null) {
            throw new IllegalArgumentException(String.format("No part at position %s was found to get the state from.", this.getPosition()));
        }
        return partStateHolder.getState();
    }

    @Override
    public boolean hasFacade() {
        return this.facadeBlockName != null && !this.facadeBlockName.isEmpty();
    }

    @Override
    public IBlockState getFacade() {
        if (!this.hasFacade()) {
            return null;
        }
        return BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)this.facadeBlockName, (Object)this.facadeMeta));
    }

    @Override
    public void setFacade(@Nullable IBlockState blockState) {
        if (blockState == null) {
            this.facadeMeta = 0;
            this.facadeBlockName = null;
        } else {
            Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)blockState);
            this.facadeMeta = (Integer)serializedBlockState.getRight();
            this.facadeBlockName = (String)serializedBlockState.getLeft();
        }
        this.sendUpdate();
    }

    public void onUpdateReceived() {
        if (!this.lightLevels.equals(this.previousLightLevels)) {
            this.previousLightLevels = this.lightLevels;
            this.func_145831_w().func_175664_x(this.func_174877_v());
        }
    }

    public IExtendedBlockState getConnectionState() {
        ExtendedBlockStateBuilder builder = ExtendedBlockStateBuilder.builder((IExtendedBlockState)((IExtendedBlockState)this.getBlock().func_176223_P()));
        if (this.partData != null) {
            builder.withProperty(BlockCable.REALCABLE, (Object)this.isRealCable());
            if (this.connected.isEmpty()) {
                this.updateConnections();
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                builder.withProperty(BlockCable.CONNECTED[side.ordinal()], (Object)(!this.isForceDisconnected(side) && (Boolean)this.connected.get((Object)side) != false ? 1 : 0));
                builder.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)(this.hasPart(side) ? this.getPart(side).getRenderPosition() : IPartType.RenderPosition.NONE));
            }
            builder.withProperty(BlockCable.FACADE, (Object)(this.hasFacade() ? Optional.of((Object)this.getFacade()) : Optional.absent()));
            builder.withProperty(BlockCable.PARTCONTAINER, (Object)this);
        }
        return builder.build();
    }

    public boolean isForceDisconnected(EnumFacing side) {
        if (!this.isRealCable() || this.hasPart(side)) {
            return true;
        }
        if (!this.forceDisconnected.containsKey((Object)side)) {
            return false;
        }
        return (Boolean)this.forceDisconnected.get((Object)side);
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.updateConnections();
        }
        if (!MinecraftHelpers.isClientSide()) {
            for (PartHelpers.PartStateHolder partStateHolder : this.partData.values()) {
                if (partStateHolder.getState().isDirtyAndReset()) {
                    this.func_70296_d();
                }
                if (!partStateHolder.getState().isUpdateAndReset()) continue;
                this.sendUpdate();
            }
        }
    }

    protected void updateRedstoneInfo(EnumFacing side) {
        this.sendUpdate();
        this.func_145831_w().func_175685_c(this.func_174877_v(), (Block)this.getBlock());
        this.func_145831_w().func_175685_c(this.field_174879_c.func_177972_a(side.func_176734_d()), (Block)this.getBlock());
    }

    public void setRedstoneLevel(EnumFacing side, int level) {
        if (!this.func_145831_w().field_72995_K) {
            boolean sendUpdate = false;
            if (this.redstoneLevels.containsKey((Object)side)) {
                if ((Integer)this.redstoneLevels.get((Object)side) != level) {
                    sendUpdate = true;
                    this.redstoneLevels.put((Enum)side, (Object)level);
                }
            } else {
                sendUpdate = true;
                this.redstoneLevels.put((Enum)side, (Object)level);
            }
            if (sendUpdate) {
                this.updateRedstoneInfo(side);
            }
        }
    }

    public int getRedstoneLevel(EnumFacing side) {
        if (this.redstoneLevels.containsKey((Object)side)) {
            return (Integer)this.redstoneLevels.get((Object)side);
        }
        return -1;
    }

    public void setAllowRedstoneInput(EnumFacing side, boolean allow) {
        this.redstoneInputs.put((Enum)side, (Object)allow);
    }

    public boolean isAllowRedstoneInput(EnumFacing side) {
        if (this.redstoneInputs.containsKey((Object)side)) {
            return (Boolean)this.redstoneInputs.get((Object)side);
        }
        return false;
    }

    public void disableRedstoneLevel(EnumFacing side) {
        if (!this.func_145831_w().field_72995_K) {
            this.redstoneLevels.remove((Object)side);
            this.updateRedstoneInfo(side);
        }
    }

    protected void updateLightInfo(EnumFacing side) {
        this.sendUpdate();
    }

    public void setLightLevel(EnumFacing side, int level) {
        if (!this.func_145831_w().field_72995_K) {
            boolean sendUpdate = false;
            if (this.lightLevels.containsKey((Object)side)) {
                if ((Integer)this.lightLevels.get((Object)side) != level) {
                    sendUpdate = true;
                    this.lightLevels.put((Enum)side, (Object)level);
                }
            } else {
                sendUpdate = true;
                this.lightLevels.put((Enum)side, (Object)level);
            }
            if (sendUpdate) {
                this.updateLightInfo(side);
            }
        }
    }

    public int getLightLevel(EnumFacing side) {
        if (this.lightLevels.containsKey((Object)side)) {
            return (Integer)this.lightLevels.get((Object)side);
        }
        return 0;
    }

    public static IPartContainer get(DimPos pos) {
        IPartContainerFacade partContainerFacade = CableHelpers.getInterface(pos, IPartContainerFacade.class);
        return partContainerFacade.getPartContainer((IBlockAccess)pos.getWorld(), pos.getBlockPos());
    }

    @Override
    public void resetCurrentNetwork() {
        if (this.network != null) {
            this.setNetwork(null);
        }
    }

    @Override
    public boolean canConnect(ICable connector, EnumFacing side) {
        return !this.isForceDisconnected(side);
    }

    @Override
    public void updateConnections() {
        World world = this.func_145831_w();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            boolean cableConnected = CableNetworkComponent.canSideConnect(world, this.field_174879_c, side, (ICable)this.getBlock());
            this.connected.put((Enum)side, (Object)cableConnected);
            if (cableConnected) continue;
            this.forceDisconnected.put((Enum)side, (Object)false);
        }
        this.func_70296_d();
        this.sendUpdate();
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return this.connected.containsKey((Object)side) && (Boolean)this.connected.get((Object)side) != false;
    }

    @Override
    public void disconnect(EnumFacing side) {
        this.forceDisconnected.put((Enum)side, (Object)true);
    }

    @Override
    public void reconnect(EnumFacing side) {
        this.forceDisconnected.remove((Object)side);
    }

    @Override
    public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
    }

    public EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> getPartData() {
        return this.partData;
    }

    public void setPartData(Map<EnumFacing, PartHelpers.PartStateHolder<?, ?>> partData) {
        this.partData.clear();
        this.partData.putAll(partData);
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public void setForceDisconnected(EnumFacingMap<Boolean> forceDisconnected) {
        this.forceDisconnected.clear();
        this.forceDisconnected.putAll(forceDisconnected);
    }

    public void silentResetPartData() {
        this.partData.clear();
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        IPartState partState;
        if (facing == null) {
            for (Map.Entry entry : this.partData.entrySet()) {
                Object partState2 = ((PartHelpers.PartStateHolder)entry.getValue()).getState();
                if (partState2 == null || !partState2.hasCapability(capability)) continue;
                return true;
            }
        } else if (this.hasPart(facing) && (partState = this.getPartState(facing)) != null && partState.hasCapability(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            for (Map.Entry entry : this.partData.entrySet()) {
                Object partState = ((PartHelpers.PartStateHolder)entry.getValue()).getState();
                if (partState == null || !partState.hasCapability(capability)) continue;
                return partState.getCapability(capability);
            }
        } else {
            IPartState partState = this.getPartState(facing);
            if (partState != null && partState.hasCapability(capability)) {
                return partState.getCapability(capability);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public IPartNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(IPartNetwork network) {
        this.network = network;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

