/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableNetwork;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkComponent;

public class TileCableNetworkComponent
implements ITileCableNetwork {
    private final CyclopsTileEntity tile;
    private final IConnectionsMapProvider connectionsMapProvider;
    private IPartNetwork network;

    public <T extends CyclopsTileEntity> TileCableNetworkComponent(T tile) {
        this.tile = tile;
        this.connectionsMapProvider = (IConnectionsMapProvider)tile;
    }

    public void updateTileEntity() {
        if (this.getConnections().isEmpty()) {
            this.updateConnections();
        }
    }

    protected Map<Integer, Boolean> getConnections() {
        return this.connectionsMapProvider.getConnections();
    }

    @Override
    public void resetCurrentNetwork() {
        if (this.network != null) {
            this.setNetwork(null);
        }
    }

    @Override
    public boolean canConnect(ICable connector, EnumFacing side) {
        return true;
    }

    @Override
    public void updateConnections() {
        World world = this.tile.func_145831_w();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            boolean cableConnected = CableNetworkComponent.canSideConnect(world, this.tile.func_174877_v(), side, (ICable)this.tile.getBlock());
            this.getConnections().put(side.ordinal(), cableConnected);
        }
        this.tile.func_70296_d();
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        return this.getConnections().containsKey(side.ordinal()) && this.getConnections().get(side.ordinal()) != false;
    }

    @Override
    public void disconnect(EnumFacing side) {
    }

    @Override
    public void reconnect(EnumFacing side) {
    }

    @Override
    public IPartNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(IPartNetwork network) {
        this.network = network;
    }

    public static interface IConnectionsMapProvider {
        public Map<Integer, Boolean> getConnections();
    }
}

