/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.xml;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.ItemAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.xml.SuperRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;
import org.w3c.dom.Element;

public class DryingBasinRecipeTypeHandler
extends SuperRecipeTypeHandler {
    protected ItemStack handleRecipe(RecipeHandler recipeHandler, Element input, Element output, Element properties) throws XmlRecipeLoader.XmlRecipeException {
        Object inputItem = null;
        ItemStack outputItem = null;
        FluidStack inputFluid = null;
        FluidStack outputFluid = null;
        if (input.getElementsByTagName("item").getLength() > 0) {
            inputItem = this.getItem(recipeHandler, input.getElementsByTagName("item").item(0));
        }
        if (input.getElementsByTagName("fluid").getLength() > 0) {
            inputFluid = this.getFluid(recipeHandler, input.getElementsByTagName("fluid").item(0));
        }
        if (output.getElementsByTagName("item").getLength() > 0) {
            outputItem = (ItemStack)this.getItem(recipeHandler, output.getElementsByTagName("item").item(0));
        }
        if (output.getElementsByTagName("fluid").getLength() > 0) {
            outputFluid = this.getFluid(recipeHandler, output.getElementsByTagName("fluid").item(0));
        }
        if (inputFluid != null && outputFluid != null) {
            throw new XmlRecipeLoader.XmlRecipeException(String.format("Can't have an input and output fluid: %s and %s", inputFluid.getLocalizedName(), outputFluid.getLocalizedName()));
        }
        int duration = Integer.parseInt(properties.getElementsByTagName("duration").item(0).getTextContent());
        ItemAndFluidStackRecipeComponent inputRecipeComponent = inputItem == null || inputItem instanceof ItemStack ? new ItemAndFluidStackRecipeComponent((ItemStack)inputItem, inputFluid) : new ItemAndFluidStackRecipeComponent((String)inputItem, inputFluid);
        ItemAndFluidStackRecipeComponent outputRecipeComponent = new ItemAndFluidStackRecipeComponent(outputItem, outputFluid);
        BlockDryingBasin.getInstance().getRecipeRegistry().registerRecipe((IRecipeInput)inputRecipeComponent, (IRecipeOutput)outputRecipeComponent, (IRecipeProperties)new DurationRecipeProperties(duration));
        return outputItem;
    }
}

