/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.write;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.client.gui.GuiPartWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.PartTypeAspects;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartWriter;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartTypeWriteBase<P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>>
extends PartTypeAspects<P, S>
implements IPartTypeWriter<P, S> {
    public PartTypeWriteBase(String name) {
        super(name, new IPartType.RenderPosition(0.3125f, 0.3125f, 0.25f, 0.25f));
    }

    @Override
    protected Map<Class<? extends INetworkEvent<IPartNetwork>>, PartTypeBase.IEventAction> constructNetworkEventActions() {
        Map<Class<? extends INetworkEvent<IPartNetwork>>, PartTypeBase.IEventAction> actions = super.constructNetworkEventActions();
        actions.put(VariableContentsUpdatedEvent.class, new PartTypeBase.IEventAction<P, S, VariableContentsUpdatedEvent>(){

            @Override
            public void onAction(IPartNetwork network, PartTarget target, S state, VariableContentsUpdatedEvent event) {
                PartTypeWriteBase.this.onVariableContentsUpdated((IPartNetwork)event.getNetwork(), target, state);
            }
        });
        return actions;
    }

    @Override
    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus((ExtendedConfig)blockConfig);
    }

    @Override
    public Class<? super P> getPartTypeClass() {
        return IPartTypeWriter.class;
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement) {
        for (int i = 0; i < state.getInventory().func_70302_i_(); ++i) {
            ItemStack itemStack = state.getInventory().func_70301_a(i);
            if (itemStack == null) continue;
            itemStacks.add(itemStack);
        }
        state.getInventory().func_174888_l();
        state.triggerAspectInfoUpdate((PartTypeWriteBase)this, target, null);
        super.addDrops(target, state, itemStacks, dropMainElement);
    }

    @Override
    public void beforeNetworkKill(IPartNetwork network, PartTarget target, S state) {
        super.beforeNetworkKill(network, target, state);
        state.triggerAspectInfoUpdate((PartTypeWriteBase)this, target, null);
    }

    @Override
    public void afterNetworkAlive(IPartNetwork network, PartTarget target, S state) {
        super.afterNetworkAlive(network, target, state);
        this.updateActivation(target, state);
    }

    @Override
    public List<IAspectWrite> getWriteAspects() {
        return Aspects.REGISTRY.getWriteAspects(this);
    }

    @Override
    public <V extends IValue> IVariable<V> getActiveVariable(IPartNetwork network, PartTarget target, S partState) {
        return partState.getVariable(network);
    }

    @Override
    public IAspectWrite getActiveAspect(PartTarget target, S partState) {
        return partState.getActiveAspect();
    }

    @Override
    public void updateActivation(PartTarget target, S partState) {
        int activeIndex = -1;
        for (int i = 0; i < partState.getInventory().func_70302_i_(); ++i) {
            if (partState.getInventory().func_70301_a(i) == null) continue;
            activeIndex = i;
            break;
        }
        IAspectWrite aspect = activeIndex == -1 ? null : this.getWriteAspects().get(activeIndex);
        partState.triggerAspectInfoUpdate((PartTypeWriteBase)this, target, aspect);
    }

    protected void onVariableContentsUpdated(IPartNetwork network, PartTarget target, S state) {
        state.onVariableContentsUpdated((PartTypeWriteBase)this, target);
    }

    protected IgnoredBlockStatus.Status getStatus(IPartStateWriter state) {
        IgnoredBlockStatus.Status status = IgnoredBlockStatus.Status.INACTIVE;
        if (state != null && !state.getInventory().isEmpty()) {
            status = state.hasVariable() && state.isEnabled() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.ERROR;
        }
        return status;
    }

    @Override
    public IBlockState getBlockState(IPartContainer partContainer, EnumFacing side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (IPartStateWriter)partContainer.getPartState(side) : null);
        return this.getBlock().func_176223_P().func_177226_a((IProperty)IgnoredBlock.FACING, (Comparable)side).func_177226_a((IProperty)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    public Class<? extends Container> getContainer() {
        return ContainerPartWriter.class;
    }

    @Override
    public void loadTooltip(S state, List<String> lines) {
        super.loadTooltip(state, lines);
        IAspectWrite aspectWrite = state.getActiveAspect();
        if (aspectWrite != null) {
            if (state.hasVariable() && state.isEnabled()) {
                lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.writer.activeAspect", (Object[])new Object[]{L10NHelpers.localize((String)aspectWrite.getUnlocalizedName()), aspectWrite.getValueType().getDisplayColorFormat() + L10NHelpers.localize((String)aspectWrite.getValueType().getUnlocalizedName()) + TextFormatting.RESET}));
            } else {
                lines.add(TextFormatting.RED + L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.errors"));
                for (L10NHelpers.UnlocalizedString error : state.getErrors(aspectWrite)) {
                    lines.add(TextFormatting.RED + error.localize());
                }
            }
        } else {
            lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.inactive"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiPartWriter.class;
    }

    @Override
    public boolean shouldTriggerBlockRenderUpdate(@Nullable S oldPartState, @Nullable S newPartState) {
        return super.shouldTriggerBlockRenderUpdate(oldPartState, newPartState) || this.getStatus((IPartStateWriter)oldPartState) != this.getStatus((IPartStateWriter)newPartState);
    }
}

