/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect;

import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;

public abstract class LazyAspectVariable<V extends IValue>
implements IAspectVariable<V> {
    private final IValueType<V> type;
    private final PartTarget target;
    private final IAspectRead<V, ?> aspect;
    @NonNull
    private V value;
    private IAspectProperties cachedProperties = null;

    public LazyAspectVariable(IValueType<V> type, PartTarget target, IAspectRead<V, ?> aspect) {
        this.type = type;
        this.target = target;
        this.aspect = aspect;
    }

    @Override
    public boolean requiresUpdate() {
        return this.value != null;
    }

    @Override
    public void update() {
        this.value = null;
        this.cachedProperties = null;
    }

    @Override
    public V getValue() {
        if (this.value == null) {
            this.value = this.getValueLazy();
        }
        return this.value;
    }

    protected IAspectProperties getAspectProperties() {
        PartPos pos;
        Pair<IPartType, IPartState> partData;
        if (this.cachedProperties == null && this.getAspect().hasProperties() && (partData = PartPos.getPartData(pos = this.getTarget().getCenter())) != null) {
            this.cachedProperties = this.getAspect().getProperties((IPartType)partData.getLeft(), this.getTarget(), (IPartState)partData.getRight());
        }
        return this.cachedProperties;
    }

    public abstract V getValueLazy();

    @Override
    public IValueType<V> getType() {
        return this.type;
    }

    @Override
    public PartTarget getTarget() {
        return this.target;
    }

    public IAspectRead<V, ?> getAspect() {
        return this.aspect;
    }
}

