/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.item.ItemPart;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;

public abstract class PartTypeBase<P extends IPartType<P, S>, S extends IPartState<P>>
implements IPartType<P, S>,
IGuiContainerProvider {
    private final Item item;
    private ItemConfig itemConfig;
    private final Block block;
    private final int guiID;
    private final String name;
    private final IPartType.RenderPosition renderPosition;
    private final Map<Class<? extends INetworkEvent<IPartNetwork>>, IEventAction> networkEventActions;

    public PartTypeBase(String name, IPartType.RenderPosition renderPosition) {
        if (this.hasGui()) {
            this.guiID = Helpers.getNewId((ModBase)this.getMod(), (Helpers.IDType)Helpers.IDType.GUI);
            this.getMod().getGuiHandler().registerGUI((IGuiContainerProvider)this, ExtendedGuiHandler.PART);
        } else {
            this.guiID = -1;
        }
        this.name = name;
        this.block = this.registerBlock();
        this.item = this.registerItem();
        this.renderPosition = renderPosition;
        this.networkEventActions = this.constructNetworkEventActions();
    }

    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlock((ExtendedConfig)blockConfig);
    }

    protected Block registerBlock() {
        BlockConfig blockConfig = new BlockConfig(this.getMod(), true, "part_" + this.getName() + "Block", null, null){

            public boolean isDisableable() {
                return false;
            }
        };
        Block block = this.createBlock(blockConfig);
        BlockAction.register((Block)block, (ExtendedConfig)blockConfig, (CreativeTabs)blockConfig.getTargetTab());
        return block;
    }

    protected Item createItem(ItemConfig itemConfig) {
        return new ItemPart((ExtendedConfig)itemConfig, this);
    }

    protected Item registerItem() {
        this.itemConfig = new ItemConfig(this.getMod(), true, "part_" + this.getName() + "Item", null, null){

            public boolean isDisableable() {
                return false;
            }
        };
        Item item = this.createItem(this.itemConfig);
        ItemAction.register((Item)item, (ExtendedConfig)this.itemConfig, (CreativeTabs)this.itemConfig.getTargetTab());
        return item;
    }

    @Override
    public ResourceLocation getBlockModelPath() {
        return new ResourceLocation(this.getMod().getModId(), "part_" + this.getName() + "Block");
    }

    @Override
    public ResourceLocation getItemModelPath() {
        return new ResourceLocation(this.getMod().getModId(), "part_" + this.getName() + "Item");
    }

    protected Map<Class<? extends INetworkEvent<IPartNetwork>>, IEventAction> constructNetworkEventActions() {
        return Maps.newHashMap();
    }

    @Override
    public final boolean hasEventSubscriptions() {
        return !this.networkEventActions.isEmpty();
    }

    @Override
    public final Set<Class<? extends INetworkEvent<IPartNetwork>>> getSubscribedEvents() {
        return this.networkEventActions.keySet();
    }

    @Override
    public final void onEvent(INetworkEvent<IPartNetwork> event, IPartNetworkElement<P, S> networkElement) {
        this.networkEventActions.get(event.getClass()).onAction(event.getNetwork(), networkElement.getTarget(), networkElement.getPartState(), event);
    }

    @Override
    public boolean isSolid(S state) {
        return false;
    }

    @Override
    public String getUnlocalizedNameBase() {
        return "parttype.parttypes." + this.getMod().getModId() + "." + this.getName();
    }

    @Override
    public String getUnlocalizedName() {
        return this.getUnlocalizedNameBase() + ".name";
    }

    @Override
    public void onInit(IInitListener.Step initStep) {
        if (MinecraftHelpers.isClientSide() && initStep == IInitListener.Step.INIT) {
            ItemAction.handleItemModel((Item)this.getItem(), (String)this.itemConfig.getNamedId(), (CreativeTabs)this.itemConfig.getTargetTab(), (String)this.getMod().getModId(), (IModelProviderConfig)this.itemConfig);
        }
    }

    @Override
    public INetworkElement<IPartNetwork> createNetworkElement(IPartContainerFacade partContainerFacade, DimPos pos, EnumFacing side) {
        return new PartNetworkElement(this, PartTarget.fromCenter(pos, side));
    }

    @Override
    public ItemStack getItemStack(S state) {
        NBTTagCompound tag = new NBTTagCompound();
        this.toNBT(tag, state);
        ItemStack itemStack = new ItemStack(this.getItem());
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    @Override
    public ItemStack getPickBlock(World world, BlockPos pos, S state) {
        return this.getItemStack(state);
    }

    @Override
    public boolean isUpdate(S state) {
        return false;
    }

    @Override
    public void update(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public S getState(ItemStack itemStack) {
        S partState = null;
        if (itemStack != null && itemStack.func_77978_p() != null) {
            partState = this.fromNBT(itemStack.func_77978_p());
        }
        if (partState == null) {
            partState = this.getDefaultState();
        }
        return partState;
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement) {
        if (dropMainElement) {
            itemStacks.add(this.getItemStack(state));
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag, S partState) {
        partState.writeToNBT(tag);
    }

    @Override
    public S fromNBT(NBTTagCompound tag) {
        S partState = this.constructDefaultState();
        partState.readFromNBT(tag);
        partState.gatherCapabilities((PartTypeBase)this);
        return partState;
    }

    protected abstract S constructDefaultState();

    @Override
    public final S getDefaultState() {
        S defaultState = this.constructDefaultState();
        defaultState.generateId();
        defaultState.gatherCapabilities((PartTypeBase)this);
        return defaultState;
    }

    @Override
    public void setUpdateInterval(S state, int updateInterval) {
        state.setUpdateInterval(updateInterval);
    }

    @Override
    public int getUpdateInterval(S state) {
        return state.getUpdateInterval();
    }

    @Override
    public void beforeNetworkKill(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public void afterNetworkAlive(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public void afterNetworkReAlive(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public void onNetworkAddition(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public void onNetworkRemoval(IPartNetwork network, PartTarget target, S state) {
    }

    protected boolean hasGui() {
        return true;
    }

    public ModBase getMod() {
        return IntegratedDynamics._instance;
    }

    @Override
    public boolean onPartActivated(World world, BlockPos pos, S partState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() || !partState.isEnabled()) {
            return false;
        }
        if (this.hasGui()) {
            this.getMod().getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)side);
            if (!world.field_72995_K && this.hasGui()) {
                player.openGui((Object)this.getMod().getModId(), this.getGuiID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    @Override
    public void onPreRemoved(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public void onPostRemoved(IPartNetwork network, PartTarget target, S state) {
    }

    @Override
    public void onBlockNeighborChange(IPartNetwork network, PartTarget target, S state, IBlockAccess world, Block neighborBlock) {
    }

    @Override
    public IBlockState getBlockState(IPartContainer partContainer, EnumFacing side) {
        return this.getBlock().func_176223_P().func_177226_a((IProperty)IgnoredBlock.FACING, (Comparable)side);
    }

    @Override
    public BlockStateContainer getBaseBlockState() {
        return this.getBlock().func_176194_O();
    }

    @Override
    public int getConsumptionRate(S state) {
        return 0;
    }

    @Override
    public void postUpdate(IPartNetwork network, PartTarget target, S state, boolean updated) {
        this.setEnabled(state, updated);
    }

    @Override
    public boolean isEnabled(S state) {
        return state.isEnabled();
    }

    @Override
    public void setEnabled(S state, boolean enabled) {
        state.setEnabled(enabled);
    }

    @Override
    public void loadTooltip(S state, List<String> lines) {
        if (!state.isEnabled()) {
            lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.disabled"));
        }
        lines.add(L10NHelpers.localize((String)"item.items.integrateddynamics.general.id", (Object[])new Object[]{state.getId()}));
    }

    @Override
    public boolean shouldTriggerBlockRenderUpdate(@Nullable S oldPartState, @Nullable S newPartState) {
        return oldPartState == null || newPartState == null;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPartType.RenderPosition getRenderPosition() {
        return this.renderPosition;
    }

    public static interface IEventAction<P extends IPartType<P, S>, S extends IPartState<P>, E extends INetworkEvent> {
        public void onAction(IPartNetwork var1, PartTarget var2, S var3, E var4);
    }
}

