/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.CompositeMap;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IEnergyBattery;
import org.cyclops.integrateddynamics.api.block.IEnergyBatteryFacade;
import org.cyclops.integrateddynamics.api.block.IVariableContainerFacade;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IEnergyConsumingNetworkElement;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.core.network.Network;
import org.cyclops.integrateddynamics.core.path.Cluster;
import org.cyclops.integrateddynamics.core.path.PathFinder;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;

public class PartNetwork
extends Network<IPartNetwork>
implements IPartNetwork,
IEnergyNetwork {
    private Map<Integer, PartPos> partPositions;
    private List<DimPos> variableContainerPositions;
    private Map<Integer, IVariableFacade> compositeVariableCache;
    private Map<Integer, IValue> lazyExpressionValueCache;
    private Map<DimPos, IEnergyBatteryFacade> energyBatteryPositions;
    private Map<Integer, DimPos> proxyPositions;
    private volatile boolean partsChanged = false;

    public PartNetwork() {
    }

    public PartNetwork(Cluster<ICablePathElement> cables) {
        super(cables);
    }

    @Override
    protected void onConstruct() {
        super.onConstruct();
        this.partPositions = Maps.newHashMap();
        this.variableContainerPositions = Lists.newArrayList();
        this.compositeVariableCache = null;
        this.lazyExpressionValueCache = Maps.newHashMap();
        this.energyBatteryPositions = Maps.newHashMap();
        this.proxyPositions = Maps.newHashMap();
    }

    @Override
    public boolean addPart(int partId, PartPos partPos) {
        if (this.partPositions.containsKey(partId)) {
            return false;
        }
        this.partPositions.put(partId, partPos);
        return true;
    }

    @Override
    public IPartState getPartState(int partId) {
        PartPos partPos = this.partPositions.get(partId);
        return TileMultipartTicking.get(partPos.getPos()).getPartState(partPos.getSide());
    }

    @Override
    public IPartType getPartType(int partId) {
        PartPos partPos = this.partPositions.get(partId);
        return TileMultipartTicking.get(partPos.getPos()).getPart(partPos.getSide());
    }

    @Override
    public void removePart(int partId) {
        this.partPositions.remove(partId);
    }

    @Override
    public boolean hasPart(int partId) {
        if (!this.partPositions.containsKey(partId)) {
            return false;
        }
        PartPos partPos = this.partPositions.get(partId);
        IPartContainer partContainer = TileMultipartTicking.get(partPos.getPos());
        return partContainer != null && partContainer.hasPart(partPos.getSide());
    }

    @Override
    public <V extends IValue> boolean hasPartVariable(int partId, IAspectRead<V, ?> aspect) {
        if (!this.hasPart(partId)) {
            return false;
        }
        IPartState partState = this.getPartState(partId);
        if (!(partState instanceof IPartStateReader)) {
            return false;
        }
        IPartType partType = this.getPartType(partId);
        if (!(partType instanceof IPartTypeReader)) {
            return false;
        }
        return ((IPartTypeReader)this.getPartType(partId)).getVariable(PartTarget.fromCenter(this.partPositions.get(partId)), (IPartStateReader)partState, aspect) != null;
    }

    @Override
    public <V extends IValue> IVariable<V> getPartVariable(int partId, IAspectRead<V, ?> aspect) {
        return ((IPartStateReader)this.getPartState(partId)).getVariable(aspect);
    }

    protected Map<Integer, IVariableFacade> getVariableCache() {
        if (this.compositeVariableCache == null) {
            CompositeMap compositeMap = new CompositeMap();
            Iterator<DimPos> it = this.variableContainerPositions.iterator();
            while (it.hasNext()) {
                BlockPos pos;
                DimPos dimPos = it.next();
                World world = dimPos.getWorld();
                Block block = world.func_180495_p(pos = dimPos.getBlockPos()).func_177230_c();
                if (block instanceof IVariableContainerFacade) {
                    compositeMap.addElement(((IVariableContainerFacade)block).getVariableContainer(world, pos).getVariableCache());
                    continue;
                }
                IntegratedDynamics.clog(Level.ERROR, "The variable container at " + dimPos + " was invalid, skipping.");
                it.remove();
            }
            this.compositeVariableCache = compositeMap;
        }
        return this.compositeVariableCache;
    }

    @Override
    public boolean hasVariableFacade(int variableId) {
        return this.getVariableCache().containsKey(variableId);
    }

    @Override
    public IVariableFacade getVariableFacade(int variableId) {
        return this.getVariableCache().get(variableId);
    }

    @Override
    public void setValue(int id, IValue value) {
        this.lazyExpressionValueCache.put(id, value);
    }

    @Override
    public boolean hasValue(int id) {
        return this.lazyExpressionValueCache.containsKey(id);
    }

    @Override
    public IValue getValue(int id) {
        return this.lazyExpressionValueCache.get(id);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PartNetwork && PartNetwork.areNetworksEqual(this, (PartNetwork)object);
    }

    @Override
    public boolean addVariableContainer(DimPos dimPos) {
        this.compositeVariableCache = null;
        return this.variableContainerPositions.add(dimPos);
    }

    @Override
    public void removeVariableContainer(DimPos dimPos) {
        this.compositeVariableCache = null;
        this.variableContainerPositions.remove(dimPos);
    }

    @Override
    public boolean addProxy(int proxyId, DimPos dimPos) {
        if (this.proxyPositions.containsKey(proxyId)) {
            return false;
        }
        this.proxyPositions.put(proxyId, dimPos);
        return true;
    }

    @Override
    public void removeProxy(int proxyId) {
        this.proxyPositions.remove(proxyId);
    }

    @Override
    public DimPos getProxy(int proxyId) {
        return this.proxyPositions.get(proxyId);
    }

    @Override
    public void notifyPartsChanged() {
        this.partsChanged = true;
    }

    private void onPartsChanged() {
    }

    @Override
    protected boolean canUpdate(INetworkElement<IPartNetwork> element) {
        if (!super.canUpdate(element)) {
            return false;
        }
        if (!(element instanceof IEnergyConsumingNetworkElement)) {
            return true;
        }
        int multiplier = GeneralConfig.energyConsumptionMultiplier;
        if (multiplier == 0) {
            return true;
        }
        int consumptionRate = ((IEnergyConsumingNetworkElement)element).getConsumptionRate() * multiplier;
        return this.consume(consumptionRate, true) == consumptionRate;
    }

    @Override
    protected void onSkipUpdate(INetworkElement<IPartNetwork> element) {
        super.onSkipUpdate(element);
        if (element instanceof IEnergyConsumingNetworkElement) {
            ((IEnergyConsumingNetworkElement)element).postUpdate(this, false);
        }
    }

    @Override
    protected void postUpdate(INetworkElement<IPartNetwork> element) {
        super.postUpdate(element);
        if (element instanceof IEnergyConsumingNetworkElement) {
            int multiplier = GeneralConfig.energyConsumptionMultiplier;
            if (multiplier > 0) {
                int consumptionRate = ((IEnergyConsumingNetworkElement)element).getConsumptionRate() * multiplier;
                this.consume(consumptionRate, false);
            }
            ((IEnergyConsumingNetworkElement)element).postUpdate(this, true);
        }
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        this.lazyExpressionValueCache.clear();
        if (this.partsChanged) {
            this.partsChanged = false;
            this.onPartsChanged();
        }
    }

    @Override
    public boolean removeCable(ICable cable, ICablePathElement cablePathElement) {
        if (super.removeCable(cable, cablePathElement)) {
            this.notifyPartsChanged();
            return true;
        }
        return false;
    }

    public static PartNetwork initiateNetworkSetup(ICable<ICablePathElement> connectable, World world, BlockPos pos) {
        PartNetwork network = new PartNetwork(PathFinder.getConnectedCluster(connectable.createPathElement(world, pos)));
        NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).addNewNetwork(network);
        return network;
    }

    protected synchronized List<IEnergyBattery> getMaterializedEnergyBatteries() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.energyBatteryPositions.entrySet(), (Function)new Function<Map.Entry<DimPos, IEnergyBatteryFacade>, IEnergyBattery>(){

            @Nullable
            public IEnergyBattery apply(Map.Entry<DimPos, IEnergyBatteryFacade> input) {
                return input.getValue().getEnergyBattery(input.getKey().getWorld(), input.getKey().getBlockPos());
            }

            public boolean equals(@Nullable Object object) {
                return false;
            }
        }));
    }

    protected int addSafe(int a, int b) {
        int add = a + b;
        if (add < a || add < b) {
            return Integer.MAX_VALUE;
        }
        return add;
    }

    @Override
    public synchronized int getStoredEnergy() {
        int energy = 0;
        for (IEnergyBattery energyBattery : this.getMaterializedEnergyBatteries()) {
            energy = this.addSafe(energy, energyBattery.getStoredEnergy());
        }
        return energy;
    }

    @Override
    public synchronized int getMaxStoredEnergy() {
        int maxEnergy = 0;
        for (IEnergyBattery energyBattery : this.getMaterializedEnergyBatteries()) {
            maxEnergy = this.addSafe(maxEnergy, energyBattery.getMaxStoredEnergy());
        }
        return maxEnergy;
    }

    @Override
    public int addEnergy(int energy, boolean simulate) {
        int toAdd = energy;
        for (IEnergyBattery energyBattery : this.getMaterializedEnergyBatteries()) {
            int maxAdd = Math.min(energyBattery.getMaxStoredEnergy() - energyBattery.getStoredEnergy(), toAdd);
            if (maxAdd > 0) {
                energyBattery.addEnergy(maxAdd, simulate);
            }
            toAdd -= maxAdd;
        }
        return energy - toAdd;
    }

    @Override
    public synchronized int consume(int energy, boolean simulate) {
        int toConsume = energy;
        for (IEnergyBattery energyBattery : this.getMaterializedEnergyBatteries()) {
            int consume = Math.min(energyBattery.getStoredEnergy(), toConsume);
            if (consume <= 0) continue;
            toConsume -= energyBattery.consume(consume, simulate);
        }
        return energy - toConsume;
    }

    @Override
    public boolean addEnergyBattery(DimPos dimPos) {
        BlockPos pos;
        World world = dimPos.getWorld();
        Block block = world.func_180495_p(pos = dimPos.getBlockPos()).func_177230_c();
        if (block instanceof IEnergyBatteryFacade) {
            return this.energyBatteryPositions.put(dimPos, (IEnergyBatteryFacade)block) == null;
        }
        return false;
    }

    @Override
    public void removeEnergyBattery(DimPos pos) {
        this.energyBatteryPositions.remove(pos);
    }

    @Override
    public Map<DimPos, IEnergyBatteryFacade> getEnergyBatteries() {
        return Collections.unmodifiableMap(this.energyBatteryPositions);
    }

    @Override
    public int getConsumptionRate() {
        int multiplier = GeneralConfig.energyConsumptionMultiplier;
        if (multiplier == 0) {
            return 0;
        }
        int consumption = 0;
        for (INetworkElement element : this.getElements()) {
            consumption += ((IEnergyConsumingNetworkElement)element).getConsumptionRate() * multiplier;
        }
        return consumption;
    }
}

