/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeElement;

public class ValueTypeElementType
implements ILogicProgrammerElementType<ValueTypeElement> {
    @Override
    public ValueTypeElement getByName(String name) {
        return this.getByValueType(ValueTypes.REGISTRY.getValueType(name));
    }

    public ValueTypeElement getByValueType(IValueType valueType) {
        return new ValueTypeElement(valueType);
    }

    @Override
    public String getName(ValueTypeElement element) {
        return element.getInnerGuiElement().getValueType().getUnlocalizedName();
    }

    @Override
    public String getName() {
        return "valuetype";
    }

    @Override
    public List<ValueTypeElement> createElements() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
            if (!valueType.hasDefaultLogicProgrammerElement()) continue;
            builder.add((Object)new ValueTypeElement(valueType));
        }
        return builder.build();
    }

    public List<IValueType> getValueTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IValueType valueType : ValueTypes.REGISTRY.getValueTypes()) {
            if (valueType.isCategory() || valueType.isObject()) continue;
            builder.add((Object)valueType);
        }
        return builder.build();
    }
}

