/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;

public class SingleElementType<E extends ILogicProgrammerElement>
implements ILogicProgrammerElementType<E> {
    private final ILogicProgrammerElementConstructor<E> constructor;
    private final String id;

    public SingleElementType(ILogicProgrammerElementConstructor<E> constructor, String id) {
        this.constructor = constructor;
        this.id = id;
    }

    @Override
    public E getByName(String name) {
        return this.constructor.construct();
    }

    @Override
    public String getName(E element) {
        return "";
    }

    @Override
    public String getName() {
        return "single:" + this.id;
    }

    @Override
    public List<E> createElements() {
        return ImmutableList.of(this.constructor.construct());
    }

    public static interface ILogicProgrammerElementConstructor<E extends ILogicProgrammerElement> {
        public E construct();
    }
}

