/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class VariableFacadeHandlerRegistry
implements IVariableFacadeHandlerRegistry {
    private static VariableFacadeHandlerRegistry INSTANCE = new VariableFacadeHandlerRegistry();
    private static DummyVariableFacade DUMMY_FACADE = new DummyVariableFacade("variable.integrateddynamics.error.invalidItem");
    private final Map<String, IVariableFacadeHandler> handlers = Maps.newHashMap();

    private VariableFacadeHandlerRegistry() {
    }

    public static VariableFacadeHandlerRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerHandler(IVariableFacadeHandler variableFacadeHandler) {
        this.handlers.put(variableFacadeHandler.getTypeId(), variableFacadeHandler);
    }

    @Override
    public IVariableFacade handle(ItemStack itemStack) {
        if (itemStack == null || !itemStack.func_77942_o()) {
            return DUMMY_FACADE;
        }
        return this.handle(itemStack.func_77978_p());
    }

    @Override
    public IVariableFacade handle(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return DUMMY_FACADE;
        }
        if (!tagCompound.func_150297_b("_type", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal()) || !tagCompound.func_150297_b("_id", MinecraftHelpers.NBTTag_Types.NBTTagInt.ordinal())) {
            return DUMMY_FACADE;
        }
        String type = tagCompound.func_74779_i("_type");
        int id = tagCompound.func_74762_e("_id");
        IVariableFacadeHandler handler = this.handlers.get(type);
        if (handler != null) {
            return handler.getVariableFacade(id, tagCompound);
        }
        return DUMMY_FACADE;
    }

    @Override
    public <F extends IVariableFacade> void write(NBTTagCompound tagCompound, F variableFacade, IVariableFacadeHandler<F> handler) {
        tagCompound.func_74778_a("_type", handler.getTypeId());
        tagCompound.func_74768_a("_id", variableFacade.getId());
        handler.setVariableFacade(tagCompound, variableFacade);
    }

    @Override
    public <F extends IVariableFacade> ItemStack writeVariableFacadeItem(boolean generateId, ItemStack itemStack, IVariableFacadeHandler<F> variableFacadeHandler, IVariableFacadeHandlerRegistry.IVariableFacadeFactory<F> variableFacadeFactory) {
        if (itemStack == null) {
            return null;
        }
        itemStack = itemStack.func_77946_l();
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        F variableFacade = this.writeVariableFacade(generateId, itemStack, variableFacadeHandler, variableFacadeFactory);
        this.write(tag, variableFacade, variableFacadeHandler);
        return itemStack;
    }

    @Override
    public <F extends IVariableFacade> F writeVariableFacade(boolean generateId, ItemStack itemStack, IVariableFacadeHandler<F> variableFacadeHandler, IVariableFacadeHandlerRegistry.IVariableFacadeFactory<F> variableFacadeFactory) {
        if (itemStack == null) {
            return null;
        }
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        IVariableFacade previousVariableFacade = this.handle(tag);
        F variableFacade = generateId && previousVariableFacade.getId() > -1 ? variableFacadeFactory.create(previousVariableFacade.getId()) : variableFacadeFactory.create(generateId);
        return variableFacade;
    }

    @Override
    public <F extends IVariableFacade> ItemStack copy(boolean generateId, ItemStack itemStack) {
        ItemStack copy = itemStack.func_77946_l();
        int newId = generateId ? VariableFacadeBase.generateId() : -1;
        copy.func_77978_p().func_74768_a("_id", newId);
        return copy;
    }

    public static class DummyVariableFacade
    extends VariableFacadeBase {
        private final String unlocalizedError;

        public DummyVariableFacade(String unlocalizedError) {
            super(false);
            this.unlocalizedError = unlocalizedError;
        }

        @Override
        public <V extends IValue> IVariable<V> getVariable(IPartNetwork network) {
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
            validator.addError(new L10NHelpers.UnlocalizedString(this.unlocalizedError, new Object[0]));
        }

        @Override
        public IValueType getOutputType() {
            return ValueTypes.CATEGORY_ANY;
        }

        @Override
        public void addInformation(List<String> list, EntityPlayer entityPlayer) {
        }

        @Override
        public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads) {
        }
    }
}

