/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;

public class CableHelpers {
    private static final List<IInterfaceRetriever> INTERFACE_RETRIEVERS = Lists.newArrayList();

    public static <C> C getInterface(IBlockAccess world, BlockPos pos, Class<C> clazz) {
        for (IInterfaceRetriever interfaceRetriever : INTERFACE_RETRIEVERS) {
            C instance = interfaceRetriever.getInterface(world, pos, clazz);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public static <C> C getInterface(DimPos dimPos, Class<C> clazz) {
        for (IInterfaceRetriever interfaceRetriever : INTERFACE_RETRIEVERS) {
            C instance = interfaceRetriever.getInterface((IBlockAccess)dimPos.getWorld(), dimPos.getBlockPos(), clazz);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    public static void addInterfaceRetriever(IInterfaceRetriever interfaceRetriever) {
        INTERFACE_RETRIEVERS.add(interfaceRetriever);
    }

    static {
        CableHelpers.addInterfaceRetriever(new IInterfaceRetriever(){

            @Override
            public <C> C getInterface(IBlockAccess world, BlockPos pos, Class<C> clazz) {
                Block block = world.func_180495_p(pos).func_177230_c();
                if (clazz.isInstance(block)) {
                    return clazz.cast(block);
                }
                return null;
            }
        });
        CableHelpers.addInterfaceRetriever(new IInterfaceRetriever(){

            @Override
            public <C> C getInterface(IBlockAccess world, BlockPos pos, Class<C> clazz) {
                return (C)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, clazz);
            }
        });
    }

    public static interface IInterfaceRetriever {
        public <C> C getInterface(IBlockAccess var1, BlockPos var2, Class<C> var3);
    }
}

