/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;

public class GuiTextFieldDropdown
extends GuiTextFieldExtended {
    private final Set<IDropdownEntry<?>> possibilities;
    private List<IDropdownEntry<?>> visiblePossibilities = Collections.emptyList();
    private int visiblePossibilitiesIndex = -1;
    private IDropdownEntry<?> selectedDropdownPossibility = null;
    private int dropdownSize = 5;
    private IDropdownEntryListener dropdownEntryListener;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public GuiTextFieldDropdown(int componentId, FontRenderer fontrenderer, int x, int y, int width, int height, boolean background, Set<IDropdownEntry<?>> possibilities) {
        super(componentId, fontrenderer, x, y, width, height, background);
        this.possibilities = Objects.requireNonNull(possibilities);
    }

    public GuiTextFieldDropdown(int componentId, FontRenderer fontrenderer, int x, int y, int width, int height, boolean background) {
        this(componentId, fontrenderer, x, y, width, height, background, Collections.emptySet());
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        this.selectedDropdownPossibility = null;
        if (!this.possibilities.isEmpty()) {
            switch (keyCode) {
                case 200: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex >= 0 ? --this.visiblePossibilitiesIndex : this.visiblePossibilities.size() - 1;
                    return true;
                }
                case 15: 
                case 208: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex < this.visiblePossibilities.size() - 1 ? ++this.visiblePossibilitiesIndex : 0;
                    return true;
                }
                case 156: 
                case 205: {
                    if (this.visiblePossibilitiesIndex < 0 || this.visiblePossibilitiesIndex >= this.visiblePossibilities.size()) break;
                    this.selectPossibility(this.visiblePossibilitiesIndex);
                    return true;
                }
            }
        }
        if (super.func_146201_a(typedChar, keyCode)) {
            if (!this.possibilities.isEmpty()) {
                this.visiblePossibilities = Lists.newArrayList();
                for (IDropdownEntry<?> possibility : this.possibilities) {
                    if (!possibility.getMatchString().toLowerCase().contains(this.func_146179_b().toLowerCase())) continue;
                    this.visiblePossibilities.add(possibility);
                }
                this.visiblePossibilitiesIndex = -1;
                if (this.visiblePossibilities.size() == 1 && this.visiblePossibilities.get(0).getMatchString().equals(this.func_146179_b())) {
                    this.selectedDropdownPossibility = this.visiblePossibilities.get(0);
                }
                if (this.dropdownEntryListener != null) {
                    this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
                }
            }
            return true;
        }
        return false;
    }

    protected void selectPossibility(int index) {
        this.visiblePossibilitiesIndex = index;
        this.selectedDropdownPossibility = this.visiblePossibilities.get(this.visiblePossibilitiesIndex);
        this.func_146180_a(this.selectedDropdownPossibility.getDisplayString());
        this.visiblePossibilities = Lists.newArrayList();
        this.visiblePossibilitiesIndex = -1;
        if (this.dropdownEntryListener != null) {
            this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
        }
    }

    public void drawTextBox(Minecraft minecraft, int mouseX, int mouseY) {
        super.drawTextBox(minecraft, mouseX, mouseY);
        if (this.func_146176_q() && this.func_146206_l()) {
            FontRenderer fontRenderer = minecraft.func_175598_ae().func_78716_a();
            int yOffset = fontRenderer.field_78288_b + 3;
            int x = this.field_146209_f;
            int y = this.field_146210_g + yOffset;
            int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
            int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
            int cy = y;
            for (int i = startIndex; i < endIndex; ++i) {
                IDropdownEntry<?> dropdownEntry = this.visiblePossibilities.get(i);
                String possibility = dropdownEntry.getDisplayString();
                String displayPossibility = fontRenderer.func_78269_a(possibility, this.func_146200_o());
                boolean active = this.visiblePossibilitiesIndex == i;
                int entryHeight = yOffset;
                boolean addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.func_146200_o(), (int)yOffset, (int)mouseX, (int)mouseY);
                List<String> tooltipLines = null;
                if (addTooltip) {
                    tooltipLines = dropdownEntry.getTooltip();
                    entryHeight += tooltipLines.size() * yOffset;
                }
                GuiTextFieldDropdown.func_73734_a((int)x, (int)(cy - 1), (int)(x + this.func_146200_o()), (int)(cy + entryHeight + 1), (int)-6250336);
                GuiTextFieldDropdown.func_73734_a((int)(x - 1), (int)cy, (int)(x + this.func_146200_o() - 1), (int)(cy + entryHeight), (int)-16777216);
                fontRenderer.func_175063_a(displayPossibility, (float)x + 1.0f, (float)cy + 2.0f, active ? this.enabledColor : this.disabledColor);
                if (addTooltip) {
                    int tooltipLineOffsetY = 2;
                    for (String tooltipLine : tooltipLines) {
                        fontRenderer.func_175063_a(tooltipLine, (float)x + 1.0f, (float)cy + (float)(tooltipLineOffsetY += yOffset), this.enabledColor);
                    }
                }
                cy += entryHeight;
            }
        }
    }

    public void func_146192_a(int mouseX, int mouseY, int mouseButton) {
        if (this.func_146176_q() && this.func_146206_l()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
            int yOffset = fontRenderer.field_78288_b + 3;
            int x = this.field_146209_f;
            int y = this.field_146210_g + yOffset;
            int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
            int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
            int cy = y;
            for (int i = startIndex; i < endIndex; ++i) {
                boolean addTooltip;
                IDropdownEntry<?> dropdownEntry = this.visiblePossibilities.get(i);
                boolean active = this.visiblePossibilitiesIndex == i;
                int entryHeight = yOffset;
                boolean bl = addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.func_146200_o(), (int)yOffset, (int)mouseX, (int)mouseY);
                if (RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.func_146200_o(), (int)yOffset, (int)mouseX, (int)mouseY)) {
                    this.selectPossibility(i);
                    return;
                }
                List<String> tooltipLines = null;
                if (addTooltip) {
                    tooltipLines = dropdownEntry.getTooltip();
                    entryHeight += tooltipLines.size() * yOffset;
                }
                cy += entryHeight;
            }
        }
        super.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public IDropdownEntry<?> getSelectedDropdownPossibility() {
        return this.selectedDropdownPossibility;
    }

    public int getDropdownSize() {
        return this.dropdownSize;
    }

    public void setDropdownSize(int dropdownSize) {
        this.dropdownSize = dropdownSize;
    }

    public IDropdownEntryListener getDropdownEntryListener() {
        return this.dropdownEntryListener;
    }

    public void setDropdownEntryListener(IDropdownEntryListener dropdownEntryListener) {
        this.dropdownEntryListener = dropdownEntryListener;
    }
}

