/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block.cable;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.cable.ICableFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICableNetwork;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableFacadeable;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkComponent;

public class CableNetworkFacadeableComponent<C extends Block>
extends CableNetworkComponent<C>
implements ICableFacadeable<ICablePathElement> {
    public CableNetworkFacadeableComponent(C cable) {
        super((ICableNetwork)cable);
    }

    @Override
    public boolean hasFacade(IBlockAccess world, BlockPos pos) {
        ITileCableFacadeable tile = (ITileCableFacadeable)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, ITileCableFacadeable.class);
        if (tile != null) {
            return tile.hasFacade();
        }
        return false;
    }

    @Override
    public IBlockState getFacade(World world, BlockPos pos) {
        ITileCableFacadeable tile = (ITileCableFacadeable)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, ITileCableFacadeable.class);
        if (tile != null) {
            return tile.getFacade();
        }
        return null;
    }

    @Override
    public void setFacade(World world, BlockPos pos, @Nullable IBlockState blockState) {
        ITileCableFacadeable tile = (ITileCableFacadeable)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, ITileCableFacadeable.class);
        if (tile != null) {
            tile.setFacade(blockState);
        }
    }
}

