/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block.cable;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.api.tileentity.ITileCable;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableNetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.network.PartNetwork;
import org.cyclops.integrateddynamics.core.path.CablePathElement;

public class CableNetworkComponent<C extends ICableNetwork<IPartNetwork, ICablePathElement>>
implements ICableNetwork<IPartNetwork, ICablePathElement> {
    protected final C cable;

    public CableNetworkComponent(C cable) {
        this.cable = cable;
    }

    @Override
    public CablePathElement createPathElement(World world, BlockPos blockPos) {
        return new CablePathElement((ICable)this.cable, DimPos.of((World)world, (BlockPos)blockPos));
    }

    protected ITileCable getTile(World world, BlockPos pos) {
        return (ITileCable)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, ITileCable.class);
    }

    protected ITileCableNetwork getTileNetwork(World world, BlockPos pos) {
        return (ITileCableNetwork)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, ITileCableNetwork.class);
    }

    @Override
    public void initNetwork(World world, BlockPos pos) {
        PartNetwork.initiateNetworkSetup(this.cable, world, pos).initialize();
    }

    @Override
    public boolean canConnect(World world, BlockPos pos, ICable connector, EnumFacing side) {
        ITileCable tile = this.getTile(world, pos);
        return tile != null && tile.canConnect(connector, side);
    }

    @Override
    public void updateConnections(World world, BlockPos pos) {
        ITileCable tile = this.getTile(world, pos);
        if (tile != null) {
            tile.updateConnections();
            world.func_175704_b(pos, pos);
        }
    }

    @Override
    public void triggerUpdateNeighbourConnections(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CableNetworkComponent.requestConnectionsUpdate(world, pos.func_177972_a(side));
        }
    }

    @Override
    public boolean isConnected(World world, BlockPos pos, EnumFacing side) {
        ITileCable tile = this.getTile(world, pos);
        return tile != null && tile.isConnected(side);
    }

    @Override
    public void disconnect(World world, BlockPos pos, EnumFacing side) {
        ITileCable tile = this.getTile(world, pos);
        if (tile != null) {
            tile.disconnect(side);
        }
    }

    @Override
    public void reconnect(World world, BlockPos pos, EnumFacing side) {
        ITileCable tile = this.getTile(world, pos);
        if (tile != null) {
            tile.reconnect(side);
        }
    }

    @Override
    public void remove(World world, BlockPos pos, EntityPlayer player) {
        ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)BlockCable.getInstance()), (EntityPlayer)player);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Override
    public void resetCurrentNetwork(World world, BlockPos pos) {
        ITileCableNetwork tile = this.getTileNetwork(world, pos);
        if (tile != null) {
            tile.resetCurrentNetwork();
        }
    }

    @Override
    public void setNetwork(IPartNetwork network, World world, BlockPos pos) {
        ITileCableNetwork tile = this.getTileNetwork(world, pos);
        if (tile != null) {
            if (network != null && tile.getNetwork() != null) {
                IntegratedDynamics.clog(Level.WARN, "Tried to set a new network for a tile without the previous one being removed.");
            }
            tile.setNetwork(network);
        }
    }

    @Override
    public IPartNetwork getNetwork(World world, BlockPos pos) {
        ITileCableNetwork tile = this.getTileNetwork(world, pos);
        if (tile != null) {
            return tile.getNetwork();
        }
        return null;
    }

    public static void requestConnectionsUpdate(World world, BlockPos pos) {
        ICable cable = CableHelpers.getInterface((IBlockAccess)world, pos, ICable.class);
        if (cable != null) {
            cable.updateConnections(world, pos);
        }
    }

    public void addToNetwork(World world, BlockPos pos) {
        this.triggerUpdateNeighbourConnections(world, pos);
        if (!world.field_72995_K) {
            this.initNetwork(world, pos);
        }
    }

    public boolean removeCableFromNetwork(World world, BlockPos pos) {
        return this.removeCableFromNetwork(world, pos, true) && this.removeCableFromNetwork(world, pos, false);
    }

    public boolean removeCableFromNetwork(World world, BlockPos pos, boolean preDestroy) {
        if (preDestroy) {
            IPartNetwork network = this.getNetwork(world, pos);
            if (network != null) {
                return network.removeCable((ICable)this.cable, this.createPathElement(world, pos));
            }
        } else {
            this.triggerUpdateNeighbourConnections(world, pos);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                BlockPos sidePos;
                ICableNetwork sideCable;
                if (world.field_72995_K || (sideCable = CableHelpers.getInterface((IBlockAccess)world, sidePos = pos.func_177972_a(side), ICableNetwork.class)) == null) continue;
                sideCable.initNetwork(world, sidePos);
            }
            this.setNetwork((IPartNetwork)null, world, pos);
        }
        return true;
    }

    public static boolean removePartFromNetwork(World world, BlockPos pos, IPartNetwork network, EnumFacing side, IPartType<?, ?> removed) {
        return CableNetworkComponent.removePartFromNetwork(world, pos, true, network, side, removed) && CableNetworkComponent.removePartFromNetwork(world, pos, false, network, side, removed);
    }

    public static boolean removePartFromNetwork(World world, BlockPos pos, boolean preDestroy, IPartNetwork network, EnumFacing side, IPartType<?, ?> removed) {
        if (preDestroy) {
            IPartContainerFacade partContainerFacade = CableHelpers.getInterface((IBlockAccess)world, pos, IPartContainerFacade.class);
            if (partContainerFacade != null && network != null) {
                IPartNetworkElement networkElement = (IPartNetworkElement)removed.createNetworkElement(partContainerFacade, DimPos.of((World)world, (BlockPos)pos), side);
                networkElement.onPreRemoved(network);
                if (network.removeNetworkElementPre(networkElement)) {
                    network.removeNetworkElementPost(networkElement);
                    networkElement.onPostRemoved(network);
                    network.notifyPartsChanged();
                    return true;
                }
                return false;
            }
        } else {
            ICableNetwork sideCable;
            BlockPos sidePos = pos.func_177972_a(side);
            CableNetworkComponent.requestConnectionsUpdate(world, sidePos);
            if (!world.field_72995_K && (sideCable = CableHelpers.getInterface((IBlockAccess)world, sidePos, ICableNetwork.class)) != null) {
                sideCable.initNetwork(world, sidePos);
            }
        }
        return true;
    }

    public boolean onPreBlockDestroyed(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            return this.removeCableFromNetwork(world, pos, true);
        }
        return true;
    }

    public boolean onPostBlockDestroyed(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            return this.removeCableFromNetwork(world, pos, false);
        }
        return true;
    }

    public static boolean canSideConnect(World world, BlockPos pos, EnumFacing side, ICable originCable) {
        BlockPos neighbourPos = pos.func_177972_a(side);
        ICable neighbourCable = CableHelpers.getInterface((IBlockAccess)world, neighbourPos, ICable.class);
        return neighbourCable != null && neighbourCable.canConnect(world, neighbourPos, originCable, side.func_176734_d());
    }
}

