/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.transfer.RecipeTransferHandlerHelper;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BasicRecipeTransferHandler<C extends Container>
implements IRecipeTransferHandler<C> {
    @Nonnull
    private final IRecipeTransferInfo<C> transferHelper;

    public BasicRecipeTransferHandler(@Nonnull IRecipeTransferInfo<C> transferHelper) {
        this.transferHelper = transferHelper;
    }

    @Override
    public Class<C> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Override
    public String getRecipeCategoryUid() {
        return this.transferHelper.getRecipeCategoryUid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull C container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        void var10_14;
        RecipeTransferHandlerHelper handlerHelper = Internal.getHelpers().recipeTransferHandlerHelper();
        StackHelper stackHelper = Internal.getStackHelper();
        if (!SessionData.isJeiOnServer()) {
            String tooltipMessage = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.no.server");
            return handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getInventorySlots(container)) {
            inventorySlots.put(slot.field_75222_d, slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots(container)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        boolean bl = false;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++var10_14;
        }
        if (var10_14 > craftingSlots.size()) {
            Log.error("Recipe Transfer helper {} does not work for container {}", this.transferHelper.getClass(), container.getClass());
            return handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            if (!slot.func_75216_d()) continue;
            if (!slot.func_82869_a(player)) {
                Log.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), slot.field_75222_d);
                return handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.field_75222_d, slot.func_75211_c().func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            if (slot.func_75216_d()) {
                availableItemStacks.put(slot.field_75222_d, slot.func_75211_c().func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - var10_14 > emptySlotCount) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.inventory.full");
            return handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.missing");
            return handlerHelper.createUserErrorForSlots(message, matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, Integer> entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= ((Container)container).field_75151_b.size()) {
                Log.error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), slotNumber, ((Container)container).field_75151_b.size());
                return handlerHelper.createInternalError();
            }
            Slot slot = container.func_75139_a(slotNumber);
            ItemStack stack = container.func_75139_a(entry.getValue().intValue()).func_75211_c();
            if (slot == null) {
                Log.error("The slot number {} does not exist in the container.", slotNumber);
                return handlerHelper.createInternalError();
            }
            if (slot.func_75214_a(stack)) continue;
            Log.error("The ItemStack {} is not valid for the slot number {}", stack, slotNumber);
            return handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer);
            JustEnoughItems.getProxy().sendPacketToServer(packet);
        }
        return null;
    }

    public static void setItems(@Nonnull EntityPlayer player, @Nonnull Map<Integer, Integer> slotIdMap, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots, boolean maxTransfer) {
        Container container = player.field_71070_bA;
        StackHelper stackHelper = Internal.getStackHelper();
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.func_75139_a(entry.getValue().intValue());
            if (slot == null || !slot.func_75216_d()) {
                return;
            }
            ItemStack itemStack = slot.func_75211_c().func_77946_l();
            itemStack.field_77994_a = 1;
            slotMap.put(entry.getKey(), itemStack);
        }
        int removedSets = BasicRecipeTransferHandler.removeSetsFromInventory(container, slotMap.values(), craftingSlots, inventorySlots, maxTransfer);
        if (removedSets == 0) {
            return;
        }
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Integer n : craftingSlots) {
            Slot craftingSlot = container.func_75139_a(n.intValue());
            if (craftingSlot == null || !craftingSlot.func_75216_d()) continue;
            ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        for (Map.Entry entry : slotMap.entrySet()) {
            Integer craftNumber = (Integer)entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.func_75139_a(slotNumber.intValue());
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_77985_e()) {
                int maxStackSize = Math.min(slot.func_178170_b(stack), stack.func_77976_d());
                int maxSets = maxStackSize / stack.field_77994_a;
                stack.field_77994_a *= Math.min(maxSets, removedSets);
            }
            slot.func_75215_d(stack);
        }
        for (ItemStack itemStack : clearedCraftingItems) {
            stackHelper.addStack(container, inventorySlots, itemStack, true);
        }
        container.func_75142_b();
    }

    private static int removeSetsFromInventory(@Nonnull Container container, @Nonnull Collection<ItemStack> required, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots, boolean maxTransfer) {
        if (maxTransfer) {
            ArrayList<ItemStack> requiredCopy = new ArrayList<ItemStack>();
            requiredCopy.addAll(required);
            int removedSets = 0;
            while (!requiredCopy.isEmpty() && BasicRecipeTransferHandler.removeSetsFromInventory(container, requiredCopy, craftingSlots, inventorySlots)) {
                ++removedSets;
                Iterator iterator = requiredCopy.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = (ItemStack)iterator.next();
                    if (stack.func_77985_e() && stack.field_77994_a * (removedSets + 1) <= stack.func_77976_d()) continue;
                    iterator.remove();
                }
            }
            return removedSets;
        }
        boolean success = BasicRecipeTransferHandler.removeSetsFromInventory(container, required, craftingSlots, inventorySlots);
        return success ? 1 : 0;
    }

    private static boolean removeSetsFromInventory(@Nonnull Container container, @Nonnull Iterable<ItemStack> required, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots) {
        HashMap<Slot, ItemStack> originalSlotContents = new HashMap<Slot, ItemStack>();
        for (ItemStack matchingStack : required) {
            ItemStack requiredStack = matchingStack.func_77946_l();
            while (requiredStack.field_77994_a > 0) {
                Slot slot = BasicRecipeTransferHandler.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                if (slot == null) {
                    for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                        ItemStack stack = (ItemStack)slotEntry.getValue();
                        ((Slot)slotEntry.getKey()).func_75215_d(stack);
                    }
                    return false;
                }
                if (!originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                }
                ItemStack removed = slot.func_75209_a(requiredStack.field_77994_a);
                requiredStack.field_77994_a -= removed.field_77994_a;
            }
        }
        return true;
    }

    private static Slot getSlotWithStack(@Nonnull Container container, @Nonnull ItemStack stack, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots) {
        StackHelper stackHelper = Internal.getStackHelper();
        Slot slot = stackHelper.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = stackHelper.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }
}

