/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.api.IItemRegistry;
import mezz.jei.config.Config;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeWrapper;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.Log;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeMaker {
    private static final Set<Class> unhandledRecipeClasses = new HashSet<Class>();

    @Nonnull
    public static List<BrewingRecipeWrapper> getBrewingRecipes(IItemRegistry itemRegistry) {
        HashSet<BrewingRecipeWrapper> recipes = new HashSet<BrewingRecipeWrapper>();
        BrewingRecipeMaker.addVanillaBrewingRecipes(itemRegistry, recipes);
        BrewingRecipeMaker.addModdedBrewingRecipes(recipes);
        ArrayList<BrewingRecipeWrapper> recipeList = new ArrayList<BrewingRecipeWrapper>(recipes);
        Collections.sort(recipeList, new Comparator<BrewingRecipeWrapper>(){

            @Override
            public int compare(BrewingRecipeWrapper o1, BrewingRecipeWrapper o2) {
                return Java6Helper.compare(o1.getBrewingSteps(), o2.getBrewingSteps());
            }
        });
        return recipeList;
    }

    private static void addVanillaBrewingRecipes(IItemRegistry itemRegistry, Collection<BrewingRecipeWrapper> recipes) {
        boolean foundNewPotions;
        ImmutableList<ItemStack> potionIngredients = itemRegistry.getPotionIngredients();
        ArrayList<ItemStack> knownPotions = new ArrayList<ItemStack>();
        ItemStack waterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
        knownPotions.add(waterBottle);
        int brewingStep = 1;
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMaker.getNewPotions(brewingStep, knownPotions, potionIngredients, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
            if (++brewingStep <= 100) continue;
            Log.error("Calculation of vanilla brewing recipes is broken, aborting after 100 brewing steps.", new Object[0]);
            return;
        } while (foundNewPotions);
    }

    private static List<ItemStack> getNewPotions(int brewingStep, List<ItemStack> knownPotions, ImmutableList<ItemStack> potionIngredients, Collection<BrewingRecipeWrapper> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionIngredient : potionIngredients) {
                BrewingRecipeWrapper recipe;
                int outputId;
                PotionType potionInputType;
                int inputId;
                PotionType potionOutputType;
                ItemStack potionOutput = PotionHelper.func_185212_d((ItemStack)potionIngredient, (ItemStack)potionInput.func_77946_l());
                if (potionOutput == null || potionInput.func_77973_b() == potionOutput.func_77973_b() && ((potionOutputType = PotionUtils.func_185191_c((ItemStack)potionOutput)) == PotionTypes.field_185230_b || (inputId = PotionType.func_185171_a((PotionType)(potionInputType = PotionUtils.func_185191_c((ItemStack)potionInput)))) == (outputId = PotionType.func_185171_a((PotionType)potionOutputType))) || recipes.contains(recipe = new BrewingRecipeWrapper(potionIngredient, potionInput.func_77946_l(), potionOutput, brewingStep))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private static void addModdedBrewingRecipes(Collection<BrewingRecipeWrapper> recipes) {
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            Class<?> recipeClass;
            BrewingRecipeWrapper recipe;
            BrewingRecipe brewingRecipe;
            if (iBrewingRecipe instanceof BrewingRecipe) {
                brewingRecipe = (BrewingRecipe)iBrewingRecipe;
                recipe = new BrewingRecipeWrapper((ItemStack)brewingRecipe.getIngredient(), brewingRecipe.getInput(), brewingRecipe.getOutput(), 0);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof BrewingOreRecipe) {
                brewingRecipe = (BrewingOreRecipe)iBrewingRecipe;
                recipe = new BrewingRecipeWrapper((List)brewingRecipe.getIngredient(), brewingRecipe.getInput(), brewingRecipe.getOutput(), 0);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe || unhandledRecipeClasses.contains(recipeClass = iBrewingRecipe.getClass())) continue;
            unhandledRecipeClasses.add(recipeClass);
            if (!Config.isDebugModeEnabled()) continue;
            Log.debug("Can't handle brewing recipe class: {}", recipeClass);
        }
    }
}

