/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.GuiItemStackFast;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.ItemStackElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;

public class GuiItemStackFastList {
    private final List<GuiItemStackFast> renderItemsAll = new ArrayList<GuiItemStackFast>();
    private final List<GuiItemStackFast> renderItemsBuiltIn = new ArrayList<GuiItemStackFast>();
    private final List<GuiItemStackFast> renderItems2d = new ArrayList<GuiItemStackFast>();
    private final List<GuiItemStackFast> renderItems3d = new ArrayList<GuiItemStackFast>();

    public void clear() {
        this.renderItemsAll.clear();
        this.renderItemsBuiltIn.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
    }

    public int size() {
        return this.renderItemsAll.size();
    }

    public void add(GuiItemStackFast guiItemStack) {
        this.renderItemsAll.add(guiItemStack);
    }

    public List<GuiItemStackFast> getAllGuiStacks() {
        return this.renderItemsAll;
    }

    public void set(int i, List<ItemStackElement> itemList) {
        this.renderItemsBuiltIn.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        for (GuiItemStackFast guiItemStack : this.renderItemsAll) {
            if (i >= itemList.size()) {
                guiItemStack.clear();
            } else {
                ItemStack stack = itemList.get(i).getItemStack();
                IBakedModel bakedModel = renderItem.func_184393_a(stack, null, null);
                if (bakedModel == null) {
                    String stackInfo = ErrorUtil.getItemStackInfo(stack);
                    throw new NullPointerException("ItemStack returned null IBakedModel from RenderItem.getItemModelWithOverrides(stack, null, null). " + stackInfo);
                }
                guiItemStack.setItemStack(stack);
                if (bakedModel.func_188618_c()) {
                    this.renderItemsBuiltIn.add(guiItemStack);
                } else if (bakedModel.func_177556_c()) {
                    this.renderItems3d.add(guiItemStack);
                } else {
                    this.renderItems2d.add(guiItemStack);
                }
            }
            ++i;
        }
    }

    @Nullable
    public Focus<?> getFocusUnderMouse(int mouseX, int mouseY) {
        GuiItemStackFast hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null) {
            return new Focus<ItemStack>(hovered.getItemStack());
        }
        return null;
    }

    @Nullable
    private GuiItemStackFast getHovered(int mouseX, int mouseY) {
        for (GuiItemStackFast guiItemStack : this.renderItemsAll) {
            if (!guiItemStack.isMouseOver(mouseX, mouseY)) continue;
            return guiItemStack;
        }
        return null;
    }

    @Nullable
    public GuiItemStackFast render(@Nonnull Minecraft minecraft, boolean isMouseOver, int mouseX, int mouseY) {
        GuiItemStackFast hovered = null;
        if (isMouseOver) {
            hovered = this.getHovered(mouseX, mouseY);
        }
        RenderHelper.func_74520_c();
        RenderItem renderItem = minecraft.func_175599_af();
        TextureManager textureManager = minecraft.func_110434_K();
        renderItem.field_77023_b += 50.0f;
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        for (GuiItemStackFast guiItemStack : this.renderItems3d) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderItemAndEffectIntoGUI();
        }
        GlStateManager.func_179140_f();
        for (GuiItemStackFast guiItemStack : this.renderItems2d) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderItemAndEffectIntoGUI();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        renderItem.field_77023_b -= 50.0f;
        for (GuiItemStackFast guiItemStack : this.renderItemsBuiltIn) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderSlow();
        }
        for (GuiItemStackFast guiItemStack : this.renderItemsAll) {
            if (hovered == guiItemStack) continue;
            guiItemStack.renderOverlay(minecraft);
        }
        RenderHelper.func_74518_a();
        return hovered;
    }
}

