/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class MasterFocus {
    private final ItemStack itemStack;
    private final FluidStack fluidStack;
    @Nonnull
    private IFocus.Mode mode = IFocus.Mode.NONE;
    private boolean allowsCheating = false;

    public static MasterFocus create(IFocus<?> focus) {
        Object value = focus.getValue();
        MasterFocus masterFocus = value instanceof ItemStack ? new MasterFocus((ItemStack)value) : (value instanceof FluidStack ? new MasterFocus((FluidStack)value) : new MasterFocus());
        masterFocus.setMode(focus.getMode());
        return masterFocus;
    }

    public MasterFocus() {
        this.itemStack = null;
        this.fluidStack = null;
    }

    public MasterFocus(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.fluidStack = MasterFocus.getFluidFromItemStack(itemStack);
    }

    public MasterFocus(FluidStack fluidStack) {
        this.itemStack = null;
        this.fluidStack = fluidStack;
    }

    @Nullable
    private static FluidStack getFluidFromItemStack(@Nonnull ItemStack stack) {
        Block block;
        Fluid fluid;
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = ((ItemBlock)item).func_179223_d()))) != null) {
            return new FluidStack(fluid, 1000);
        }
        FluidStack fluidContained = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidContained != null) {
            return fluidContained;
        }
        return null;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setMode(@Nonnull IFocus.Mode mode) {
        this.mode = mode;
    }

    @Nonnull
    public IFocus.Mode getMode() {
        return this.mode;
    }

    public void setAllowsCheating() {
        this.allowsCheating = true;
    }

    public boolean allowsCheating() {
        return this.allowsCheating;
    }

    public boolean equalsFocus(@Nonnull MasterFocus other) {
        return ItemStack.func_77989_b((ItemStack)this.itemStack, (ItemStack)other.getItemStack()) && this.fluidStack == other.getFluidStack() && this.mode == other.getMode();
    }

    @Nonnull
    public List<IRecipeCategory> getCategories() {
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        if (this.mode == IFocus.Mode.INPUT) {
            return this.getInputCategories(recipeRegistry);
        }
        if (this.mode == IFocus.Mode.OUTPUT) {
            return this.getOutputCategories(recipeRegistry);
        }
        return recipeRegistry.getRecipeCategories();
    }

    @Nonnull
    private List<IRecipeCategory> getInputCategories(@Nonnull IRecipeRegistry recipeRegistry) {
        if (this.itemStack != null && this.fluidStack != null) {
            ArrayList<IRecipeCategory> categories = new ArrayList<IRecipeCategory>(recipeRegistry.getRecipeCategoriesWithInput(this.itemStack));
            categories.addAll(recipeRegistry.getRecipeCategoriesWithInput(this.fluidStack));
            return ImmutableSet.copyOf(categories).asList();
        }
        if (this.itemStack != null) {
            return recipeRegistry.getRecipeCategoriesWithInput(this.itemStack);
        }
        return recipeRegistry.getRecipeCategoriesWithInput(this.fluidStack);
    }

    @Nonnull
    private List<IRecipeCategory> getOutputCategories(@Nonnull IRecipeRegistry recipeRegistry) {
        if (this.itemStack != null && this.fluidStack != null) {
            ArrayList<IRecipeCategory> categories = new ArrayList<IRecipeCategory>(recipeRegistry.getRecipeCategoriesWithOutput(this.itemStack));
            categories.addAll(recipeRegistry.getRecipeCategoriesWithOutput(this.fluidStack));
            return ImmutableSet.copyOf(categories).asList();
        }
        if (this.itemStack != null) {
            return recipeRegistry.getRecipeCategoriesWithOutput(this.itemStack);
        }
        return recipeRegistry.getRecipeCategoriesWithOutput(this.fluidStack);
    }

    @Nonnull
    public List<Object> getRecipes(@Nonnull IRecipeCategory recipeCategory) {
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        if (this.mode == IFocus.Mode.INPUT) {
            return this.getInputRecipes(recipeRegistry, recipeCategory);
        }
        if (this.mode == IFocus.Mode.OUTPUT) {
            return this.getOutputRecipes(recipeRegistry, recipeCategory);
        }
        return recipeRegistry.getRecipes(recipeCategory);
    }

    @Nonnull
    public Collection<ItemStack> getRecipeCategoryCraftingItems(@Nonnull IRecipeCategory recipeCategory) {
        StackHelper stackHelper;
        ItemStack matchingStack;
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        Collection<ItemStack> craftingItems = recipeRegistry.getCraftingItems(recipeCategory);
        if (this.itemStack != null && this.mode == IFocus.Mode.INPUT && (matchingStack = (stackHelper = Internal.getStackHelper()).containsStack(craftingItems, this.itemStack)) != null) {
            return Collections.singletonList(matchingStack);
        }
        return craftingItems;
    }

    @Nonnull
    private List<Object> getInputRecipes(@Nonnull IRecipeRegistry recipeRegistry, @Nonnull IRecipeCategory recipeCategory) {
        if (this.itemStack != null && this.fluidStack != null) {
            ArrayList<Object> recipes = new ArrayList<Object>(recipeRegistry.getRecipesWithInput(recipeCategory, this.itemStack));
            recipes.addAll(recipeRegistry.getRecipesWithInput(recipeCategory, this.fluidStack));
            return ImmutableSet.copyOf(recipes).asList();
        }
        if (this.itemStack != null) {
            return recipeRegistry.getRecipesWithInput(recipeCategory, this.itemStack);
        }
        return recipeRegistry.getRecipesWithInput(recipeCategory, this.fluidStack);
    }

    @Nonnull
    private List<Object> getOutputRecipes(@Nonnull IRecipeRegistry recipeRegistry, @Nonnull IRecipeCategory recipeCategory) {
        if (this.itemStack != null && this.fluidStack != null) {
            ArrayList<Object> recipes = new ArrayList<Object>(recipeRegistry.getRecipesWithOutput(recipeCategory, this.itemStack));
            recipes.addAll(recipeRegistry.getRecipesWithOutput(recipeCategory, this.fluidStack));
            return ImmutableSet.copyOf(recipes).asList();
        }
        if (this.itemStack != null) {
            return recipeRegistry.getRecipesWithOutput(recipeCategory, this.itemStack);
        }
        return recipeRegistry.getRecipesWithOutput(recipeCategory, this.fluidStack);
    }
}

